/*
 * Copyright © 2019 Benny Bottema (benny@bennybottema.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.bbottema.javasocksproxyserver.auth;

import org.bbottema.javasocksproxyserver.AuthConstants;

import static java.nio.charset.StandardCharsets.UTF_8;

public abstract class UsernamePasswordAuthenticator extends Authenticator {

    private final boolean acceptNoAuthMode;

    public UsernamePasswordAuthenticator(boolean acceptNoAuthMode) {
        this.acceptNoAuthMode = acceptNoAuthMode;
    }

    @Override
    public byte accept(byte[] authTypes) {
        if (acceptNoAuthMode) {
            for (byte type : authTypes) {
                if (type == AuthConstants.TYPE_NO_AUTH) {
                    return type;
                }
            }
        }
        for (byte type : authTypes) {
            if (type == AuthConstants.TYPE_USER_PASS_AUTH) {
                return type;
            }
        }
        return AuthConstants.NONE_ACCEPTED;
    }

    @Override
    public boolean validate(byte[] username, byte[] password) {
        return validate(new String(username, UTF_8), new String(password, UTF_8));
    }

    public abstract boolean validate(String username, String password);
}
