/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.debug.Debug;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.freedesktop.DBus;
import org.freedesktop.dbus.BusAddress;
import org.freedesktop.dbus.CallbackHandler;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.EfficientMap;
import org.freedesktop.dbus.EfficientQueue;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.ExportedObject;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.ObjectTree;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.FatalDBusException;
import org.freedesktop.dbus.exceptions.FatalException;
import org.freedesktop.dbus.exceptions.NotConnected;

public abstract class AbstractConnection {
    protected static final int TIMEOUT = 100000;
    private static final int PENDING_MAP_INITIAL_SIZE = 10;
    static final String BUSNAME_REGEX = "^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$";
    static final String CONNID_REGEX = "^:[0-9]*\\.[0-9]*$";
    static final String OBJECT_REGEX = "^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$";
    static final byte THREADCOUNT = 4;
    static final int MAX_ARRAY_LENGTH = 0x4000000;
    static final int MAX_NAME_LENGTH = 255;
    protected Map<String, ExportedObject> exportedObjects = new HashMap<String, ExportedObject>();
    private ObjectTree objectTree;
    private _globalhandler _globalhandlerreference;
    protected Map<DBusInterface, RemoteObject> importedObjects = new HashMap<DBusInterface, RemoteObject>();
    protected Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> handledSignals;
    protected EfficientMap pendingCalls;
    protected Map<MethodCall, CallbackHandler<? extends Object>> pendingCallbacks;
    protected Map<MethodCall, DBusAsyncReply<? extends Object>> pendingCallbackReplys;
    protected LinkedList<Runnable> runnables;
    protected LinkedList<_workerthread> workers;
    protected FallbackContainer fallbackcontainer;
    protected boolean _run;
    EfficientQueue outgoing;
    LinkedList<Error> pendingErrors;
    private static final Map<Thread, DBusCallInfo> infomap = new HashMap<Thread, DBusCallInfo>();
    protected _thread thread;
    protected _sender sender;
    protected Transport transport;
    protected String addr;
    protected boolean weakreferences = false;
    static final Pattern dollar_pattern = Pattern.compile("[$]");
    public static final boolean EXCEPTION_DEBUG;
    static final boolean FLOAT_SUPPORT;
    protected boolean connected = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractConnection(String address) throws DBusException {
        this._globalhandlerreference = new _globalhandler();
        Object object = this.exportedObjects;
        synchronized (object) {
            this.exportedObjects.put(null, new ExportedObject(this._globalhandlerreference, this.weakreferences));
        }
        this.handledSignals = new HashMap<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>>();
        this.pendingCalls = new EfficientMap(10);
        this.outgoing = new EfficientQueue(10);
        this.pendingCallbacks = new HashMap<MethodCall, CallbackHandler<? extends Object>>();
        this.pendingCallbackReplys = new HashMap<MethodCall, DBusAsyncReply<? extends Object>>();
        this.pendingErrors = new LinkedList();
        this.runnables = new LinkedList();
        this.workers = new LinkedList();
        this.objectTree = new ObjectTree();
        this.fallbackcontainer = new FallbackContainer();
        object = this.workers;
        synchronized (object) {
            for (int i = 0; i < 4; ++i) {
                _workerthread t = new _workerthread();
                t.start();
                this.workers.add(t);
            }
        }
        this._run = true;
        this.addr = address;
    }

    protected void listen() {
        this.thread = new _thread();
        this.thread.start();
        this.sender = new _sender();
        this.sender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeThreadCount(byte newcount) {
        LinkedList<_workerthread> linkedList = this.workers;
        synchronized (linkedList) {
            if (this.workers.size() > newcount) {
                int n = this.workers.size() - newcount;
                for (int i = 0; i < n; ++i) {
                    _workerthread t = this.workers.removeFirst();
                    t.halt();
                }
            } else if (this.workers.size() < newcount) {
                int n = newcount - this.workers.size();
                for (int i = 0; i < n; ++i) {
                    _workerthread t = new _workerthread();
                    t.start();
                    this.workers.add(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunnable(Runnable r) {
        LinkedList<Runnable> linkedList = this.runnables;
        synchronized (linkedList) {
            this.runnables.add(r);
            this.runnables.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getExportedObject(DBusInterface i) throws DBusException {
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            for (String s : this.exportedObjects.keySet()) {
                if (!i.equals(this.exportedObjects.get((Object)s).object.get())) continue;
                return s;
            }
        }
        String s = this.importedObjects.get((Object)i).objectpath;
        if (null != s) {
            return s;
        }
        throw new DBusException("Not an object exported or imported by this connection");
    }

    abstract DBusInterface getExportedObject(String var1, String var2) throws DBusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusCallInfo getCallInfo() {
        DBusCallInfo info;
        Map<Thread, DBusCallInfo> map = infomap;
        synchronized (map) {
            info = infomap.get(Thread.currentThread());
        }
        return info;
    }

    public void setWeakReferences(boolean weakreferences) {
        this.weakreferences = weakreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportObject(String objectpath, DBusInterface object) throws DBusException {
        if (null == objectpath || "".equals(objectpath)) {
            throw new DBusException(Gettext._("Must Specify an Object Path"));
        }
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + objectpath);
        }
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            if (null != this.exportedObjects.get(objectpath)) {
                throw new DBusException(Gettext._("Object already exported"));
            }
            ExportedObject eo = new ExportedObject(object, this.weakreferences);
            this.exportedObjects.put(objectpath, eo);
            this.objectTree.add(objectpath, eo, eo.introspectiondata);
        }
    }

    public void addFallback(String objectprefix, DBusInterface object) throws DBusException {
        if (null == objectprefix || "".equals(objectprefix)) {
            throw new DBusException(Gettext._("Must Specify an Object Path"));
        }
        if (!objectprefix.matches(OBJECT_REGEX) || objectprefix.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + objectprefix);
        }
        ExportedObject eo = new ExportedObject(object, this.weakreferences);
        this.fallbackcontainer.add(objectprefix, eo);
    }

    public void removeFallback(String objectprefix) {
        this.fallbackcontainer.remove(objectprefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unExportObject(String objectpath) {
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            this.exportedObjects.remove(objectpath);
            this.objectTree.remove(objectpath);
        }
    }

    public void sendSignal(DBusSignal signal) {
        this.queueOutgoing(signal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueOutgoing(Message m) {
        EfficientQueue efficientQueue = this.outgoing;
        synchronized (efficientQueue) {
            if (null == this.outgoing) {
                return;
            }
            this.outgoing.add(m);
            this.outgoing.notifyAll();
        }
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        this.removeSigHandler(new DBusMatchRule(type), handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> type, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        String objectpath = this.importedObjects.get((Object)object).objectpath;
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(type, null, objectpath), handler);
    }

    protected abstract <T extends DBusSignal> void removeSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    public <T extends DBusSignal> void addSigHandler(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        this.addSigHandler(new DBusMatchRule(type), handler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> type, DBusInterface object, DBusSigHandler<T> handler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(type)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        String objectpath = this.importedObjects.get((Object)object).objectpath;
        if (!objectpath.matches(OBJECT_REGEX) || objectpath.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + objectpath);
        }
        this.addSigHandler(new DBusMatchRule(type, null, objectpath), handler);
    }

    protected abstract <T extends DBusSignal> void addSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends DBusSignal> void addSigHandlerWithoutMatch(Class<? extends DBusSignal> signal, DBusSigHandler<T> handler) throws DBusException {
        DBusMatchRule rule = new DBusMatchRule(signal);
        SignalTuple key = new SignalTuple(rule.getInterface(), rule.getMember(), rule.getObject(), rule.getSource());
        Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<DBusSignal>> v = this.handledSignals.get(key);
            if (null == v) {
                v = new Vector();
                v.add(handler);
                this.handledSignals.put(key, v);
            } else {
                v.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object ee2;
        this.connected = false;
        try {
            this.handleMessage(new DBus.Local.Disconnected("/"));
        }
        catch (Exception ee2) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
        }
        while (this.runnables.size() > 0) {
            ee2 = this.runnables;
            synchronized (ee2) {
                this.runnables.notifyAll();
            }
        }
        this._run = false;
        ee2 = this.outgoing;
        synchronized (ee2) {
            this.outgoing.notifyAll();
        }
        try {
            if (null != this.transport) {
                this.transport.disconnect();
                this.transport = null;
            }
        }
        catch (IOException IOe) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
        }
        LinkedList<Runnable> linkedList = this.workers;
        synchronized (linkedList) {
            for (_workerthread t : this.workers) {
                t.halt();
            }
        }
        linkedList = this.runnables;
        synchronized (linkedList) {
            this.runnables.notifyAll();
        }
    }

    public void finalize() {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBusExecutionException getError() {
        LinkedList<Error> linkedList = this.pendingErrors;
        synchronized (linkedList) {
            if (this.pendingErrors.size() == 0) {
                return null;
            }
            return this.pendingErrors.removeFirst().getException();
        }
    }

    public <A> void callWithCallback(DBusInterface object, String m, CallbackHandler<A> callback, Object ... parameters) {
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getClass();
        }
        RemoteObject ro = this.importedObjects.get(object);
        try {
            Method me = null == ro.iface ? object.getClass().getMethod(m, types) : ro.iface.getMethod(m, types);
            RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 2, callback, parameters);
        }
        catch (DBusExecutionException DBEe) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw DBEe;
        }
        catch (Exception e) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusExecutionException(e.getMessage());
        }
    }

    public DBusAsyncReply callMethodAsync(DBusInterface object, String m, Object ... parameters) {
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getClass();
        }
        RemoteObject ro = this.importedObjects.get(object);
        try {
            Method me = null == ro.iface ? object.getClass().getMethod(m, types) : ro.iface.getMethod(m, types);
            return (DBusAsyncReply)RemoteInvocationHandler.executeRemoteMethod(ro, me, this, 1, null, parameters);
        }
        catch (DBusExecutionException DBEe) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw DBEe;
        }
        catch (Exception e) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusExecutionException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final MethodCall m) throws DBusException {
        Map<String, ExportedObject> map;
        ExportedObject eo = null;
        Method meth = null;
        DBusInterface o = null;
        if (null == m.getInterface() || m.getInterface().equals("org.freedesktop.DBus.Peer") || m.getInterface().equals("org.freedesktop.DBus.Introspectable")) {
            map = this.exportedObjects;
            synchronized (map) {
                eo = this.exportedObjects.get(null);
            }
            if (null != eo && null == eo.object.get()) {
                this.unExportObject(null);
                eo = null;
            }
            if (null != eo) {
                meth = eo.methods.get(new MethodTuple(m.getName(), m.getSig()));
            }
            if (null != meth) {
                o = new _globalhandler(m.getPath());
            } else {
                eo = null;
            }
        }
        if (null == o) {
            map = this.exportedObjects;
            synchronized (map) {
                eo = this.exportedObjects.get(m.getPath());
            }
            if (null != eo && null == eo.object.get()) {
                this.unExportObject(m.getPath());
                eo = null;
            }
            if (null == eo) {
                eo = this.fallbackcontainer.get(m.getPath());
            }
            if (null == eo) {
                try {
                    this.queueOutgoing(new Error(m, new DBus.Error.UnknownObject(m.getPath() + Gettext._(" is not an object provided by this process."))));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
                return;
            }
            meth = eo.methods.get(new MethodTuple(m.getName(), m.getSig()));
            if (null == meth) {
                try {
                    this.queueOutgoing(new Error(m, new DBus.Error.UnknownMethod(MessageFormat.format(Gettext._("The method `{0}.{1}' does not exist on this object."), m.getInterface(), m.getName()))));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
                return;
            }
            o = eo.object.get();
        }
        final Method me = meth;
        final _globalhandler ob = o;
        final boolean noreply = 1 == (m.getFlags() & 1);
        final DBusCallInfo info = new DBusCallInfo(m);
        final AbstractConnection conn = this;
        this.addRunnable(new Runnable(){
            private boolean run = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                if (this.run) {
                    return;
                }
                this.run = true;
                try {
                    Type[] ts = me.getGenericParameterTypes();
                    m.setArgs(Marshalling.deSerializeParameters(m.getParameters(), ts, conn));
                }
                catch (Exception e) {
                    if (EXCEPTION_DEBUG) {
                        // empty if block
                    }
                    try {
                        conn.queueOutgoing(new Error(m, new DBus.Error.UnknownMethod(Gettext._("Failure in de-serializing message: ") + e)));
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    Object result;
                    Map e = infomap;
                    synchronized (e) {
                        infomap.put(Thread.currentThread(), info);
                    }
                    try {
                        result = me.invoke(ob, m.getParameters());
                    }
                    catch (InvocationTargetException ITe) {
                        if (EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        throw ITe.getCause();
                    }
                    Map ITe = infomap;
                    synchronized (ITe) {
                        infomap.remove(Thread.currentThread());
                    }
                    if (!noreply) {
                        MethodReturn reply;
                        if (Void.TYPE.equals(me.getReturnType())) {
                            reply = new MethodReturn(m, null, new Object[0]);
                        } else {
                            StringBuffer sb = new StringBuffer();
                            for (String s : Marshalling.getDBusType(me.getGenericReturnType())) {
                                sb.append(s);
                            }
                            Object[] nr = Marshalling.convertParameters(new Object[]{result}, new Type[]{me.getGenericReturnType()}, conn);
                            reply = new MethodReturn(m, sb.toString(), nr);
                        }
                        conn.queueOutgoing(reply);
                    }
                }
                catch (DBusExecutionException DBEe) {
                    if (EXCEPTION_DEBUG) {
                        // empty if block
                    }
                    try {
                        conn.queueOutgoing(new Error(m, DBEe));
                    }
                    catch (DBusException dBusException) {}
                }
                catch (Throwable e) {
                    if (EXCEPTION_DEBUG) {
                        // empty if block
                    }
                    try {
                        conn.queueOutgoing(new Error(m, new DBusExecutionException(MessageFormat.format(Gettext._("Error Executing Method {0}.{1}: {2}"), m.getInterface(), m.getName(), e.getMessage()))));
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final DBusSignal s) {
        Vector<DBusSigHandler<? extends DBusSignal>> v = new Vector<DBusSigHandler<? extends DBusSignal>>();
        Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<? extends DBusSignal>> t = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), null, null));
            if (null != t) {
                v.addAll(t);
            }
            if (null != (t = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), s.getPath(), null)))) {
                v.addAll(t);
            }
            if (null != (t = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), null, s.getSource())))) {
                v.addAll(t);
            }
            if (null != (t = this.handledSignals.get(new SignalTuple(s.getInterface(), s.getName(), s.getPath(), s.getSource())))) {
                v.addAll(t);
            }
        }
        if (0 == v.size()) {
            return;
        }
        final AbstractConnection conn = this;
        for (final DBusSigHandler dBusSigHandler : v) {
            this.addRunnable(new Runnable(){
                private boolean run = false;

                @Override
                public synchronized void run() {
                    if (this.run) {
                        return;
                    }
                    this.run = true;
                    try {
                        DBusSignal rs = s instanceof DBusSignal.internalsig || s.getClass().equals(DBusSignal.class) ? s.createReal(conn) : s;
                        dBusSigHandler.handle(rs);
                    }
                    catch (DBusException DBe) {
                        if (EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        try {
                            conn.queueOutgoing(new Error(s, new DBusExecutionException("Error handling signal " + s.getInterface() + "." + s.getName() + ": " + DBe.getMessage())));
                        }
                        catch (DBusException dBusException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final Error err) {
        MethodCall m = null;
        if (null == this.pendingCalls) {
            return;
        }
        Object object = this.pendingCalls;
        synchronized (object) {
            if (this.pendingCalls.contains(err.getReplySerial())) {
                m = this.pendingCalls.remove(err.getReplySerial());
            }
        }
        if (null != m) {
            m.setReply(err);
            CallbackHandler<? extends Object> cbh = null;
            DBusAsyncReply<? extends Object> asr = null;
            Map<MethodCall, CallbackHandler<? extends Object>> map = this.pendingCallbacks;
            synchronized (map) {
                cbh = this.pendingCallbacks.remove(m);
                asr = this.pendingCallbackReplys.remove(m);
            }
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                this.addRunnable(new Runnable(){
                    private boolean run = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public synchronized void run() {
                        if (this.run) {
                            return;
                        }
                        this.run = true;
                        try {
                            DBusCallInfo info = new DBusCallInfo(err);
                            Map map = infomap;
                            synchronized (map) {
                                infomap.put(Thread.currentThread(), info);
                            }
                            fcbh.handleError(err.getException());
                            map = infomap;
                            synchronized (map) {
                                infomap.remove(Thread.currentThread());
                            }
                        }
                        catch (Exception e) {
                            if (EXCEPTION_DEBUG) {
                                // empty if block
                            }
                        }
                    }
                });
            }
        } else {
            object = this.pendingErrors;
            synchronized (object) {
                this.pendingErrors.addLast(err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final MethodReturn mr) {
        MethodCall m = null;
        if (null == this.pendingCalls) {
            return;
        }
        EfficientMap efficientMap = this.pendingCalls;
        synchronized (efficientMap) {
            if (this.pendingCalls.contains(mr.getReplySerial())) {
                m = this.pendingCalls.remove(mr.getReplySerial());
            }
        }
        if (null != m) {
            m.setReply(mr);
            mr.setCall(m);
            CallbackHandler<? extends Object> cbh = null;
            DBusAsyncReply<? extends Object> asr = null;
            Map<MethodCall, CallbackHandler<? extends Object>> map = this.pendingCallbacks;
            synchronized (map) {
                cbh = this.pendingCallbacks.remove(m);
                asr = this.pendingCallbackReplys.remove(m);
            }
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                final DBusAsyncReply<? extends Object> fasr = asr;
                this.addRunnable(new Runnable(){
                    private boolean run = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public synchronized void run() {
                        if (this.run) {
                            return;
                        }
                        this.run = true;
                        try {
                            DBusCallInfo info = new DBusCallInfo(mr);
                            Map map = infomap;
                            synchronized (map) {
                                infomap.put(Thread.currentThread(), info);
                            }
                            fcbh.handle(RemoteInvocationHandler.convertRV(mr.getSig(), mr.getParameters(), fasr.getMethod(), fasr.getConnection()));
                            map = infomap;
                            synchronized (map) {
                                infomap.remove(Thread.currentThread());
                            }
                        }
                        catch (Exception e) {
                            if (EXCEPTION_DEBUG) {
                                // empty if block
                            }
                        }
                    }
                });
            }
        } else {
            try {
                this.queueOutgoing(new Error(mr, new DBusExecutionException(Gettext._("Spurious reply. No message with the given serial id was awaiting a reply."))));
            }
            catch (DBusException dBusException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendMessage(Message m) {
        try {
            if (!this.connected) {
                throw new NotConnected(Gettext._("Disconnected"));
            }
            if (m instanceof DBusSignal) {
                ((DBusSignal)m).appendbody(this);
            }
            if (m instanceof MethodCall && 0 == (m.getFlags() & 1)) {
                if (null == this.pendingCalls) {
                    ((MethodCall)m).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", Gettext._("Disconnected")));
                } else {
                    EfficientMap efficientMap = this.pendingCalls;
                    synchronized (efficientMap) {
                        this.pendingCalls.put(m.getSerial(), (MethodCall)m);
                    }
                }
            }
            this.transport.mout.writeMessage(m);
            return;
        }
        catch (Exception e) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            if (m instanceof MethodCall && e instanceof NotConnected) {
                try {
                    ((MethodCall)m).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", Gettext._("Disconnected")));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
            }
            if (m instanceof MethodCall && e instanceof DBusExecutionException) {
                try {
                    ((MethodCall)m).setReply(new Error(m, e));
                }
                catch (DBusException dBusException) {}
            } else if (m instanceof MethodCall) {
                try {
                    ((MethodCall)m).setReply(new Error(m, new DBusExecutionException(Gettext._("Message Failed to Send: ") + e.getMessage())));
                }
                catch (DBusException dBusException) {}
            } else if (m instanceof MethodReturn) {
                try {
                    this.transport.mout.writeMessage(new Error(m, e));
                }
                catch (IOException IOe) {
                    if (!EXCEPTION_DEBUG) {
                        // empty if block
                    }
                }
                catch (DBusException IOe) {
                    if (EXCEPTION_DEBUG) {
                        // empty if block
                    }
                }
            }
            if (!(e instanceof IOException)) return;
            this.disconnect();
        }
    }

    private Message readIncoming() throws DBusException {
        if (!this.connected) {
            throw new NotConnected(Gettext._("No transport present"));
        }
        Message m = null;
        try {
            m = this.transport.min.readMessage();
        }
        catch (IOException IOe) {
            throw new FatalDBusException(IOe.getMessage());
        }
        return m;
    }

    public BusAddress getAddress() throws ParseException {
        return new BusAddress(this.addr);
    }

    static {
        FLOAT_SUPPORT = null != System.getenv("DBUS_JAVA_FLOATS");
        boolean bl = EXCEPTION_DEBUG = null != System.getenv("DBUS_JAVA_EXCEPTION_DEBUG");
        if (EXCEPTION_DEBUG) {
            Debug.print((Object)"Debugging of internal exceptions enabled");
            Debug.setThrowableTraces((boolean)true);
        }
    }

    private class _sender
    extends Thread {
        public _sender() {
            this.setName("Sender");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Message m = null;
            while (AbstractConnection.this._run) {
                if (null != AbstractConnection.this.outgoing) {
                    EfficientQueue efficientQueue = AbstractConnection.this.outgoing;
                    synchronized (efficientQueue) {
                        while (AbstractConnection.this.outgoing.size() == 0 && AbstractConnection.this._run) {
                            try {
                                AbstractConnection.this.outgoing.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (AbstractConnection.this.outgoing.size() > 0) {
                            m = AbstractConnection.this.outgoing.remove();
                        }
                    }
                }
                if (null != m) {
                    AbstractConnection.this.sendMessage(m);
                }
                m = null;
            }
            if (null != AbstractConnection.this.outgoing) {
                do {
                    EfficientQueue ogq;
                    EfficientQueue efficientQueue = ogq = AbstractConnection.this.outgoing;
                    synchronized (efficientQueue) {
                        AbstractConnection.this.outgoing = null;
                    }
                    m = !ogq.isEmpty() ? ogq.remove() : null;
                    AbstractConnection.this.sendMessage(m);
                } while (null != m);
            }
        }
    }

    protected class _workerthread
    extends Thread {
        private boolean _run = true;

        protected _workerthread() {
        }

        public void halt() {
            this._run = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this._run) {
                Runnable r = null;
                LinkedList<Runnable> linkedList = AbstractConnection.this.runnables;
                synchronized (linkedList) {
                    while (AbstractConnection.this.runnables.size() == 0 && this._run) {
                        try {
                            AbstractConnection.this.runnables.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (AbstractConnection.this.runnables.size() > 0) {
                        r = AbstractConnection.this.runnables.removeFirst();
                    }
                }
                if (null == r) continue;
                r.run();
            }
        }
    }

    private class _globalhandler
    implements DBus.Peer,
    DBus.Introspectable {
        private String objectpath;

        public _globalhandler() {
            this.objectpath = null;
        }

        public _globalhandler(String objectpath) {
            this.objectpath = objectpath;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public void Ping() {
        }

        @Override
        public String Introspect() {
            ExportedObject eo;
            String intro = AbstractConnection.this.objectTree.Introspect(this.objectpath);
            if (null == intro && null != (eo = AbstractConnection.this.fallbackcontainer.get(this.objectpath))) {
                intro = eo.introspectiondata;
            }
            if (null == intro) {
                throw new DBus.Error.UnknownObject("Introspecting on non-existant object");
            }
            return "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n" + intro;
        }
    }

    protected class _thread
    extends Thread {
        public _thread() {
            this.setName("DBusConnection");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                _thread _thread2;
                Message m = null;
                while (AbstractConnection.this._run) {
                    m = null;
                    try {
                        m = AbstractConnection.this.readIncoming();
                        if (m == null) continue;
                        _thread2 = this;
                        synchronized (_thread2) {
                            this.notifyAll();
                        }
                        if (m instanceof DBusSignal) {
                            AbstractConnection.this.handleMessage((DBusSignal)m);
                        } else if (m instanceof MethodCall) {
                            AbstractConnection.this.handleMessage((MethodCall)m);
                        } else if (m instanceof MethodReturn) {
                            AbstractConnection.this.handleMessage((MethodReturn)m);
                        } else if (m instanceof Error) {
                            AbstractConnection.this.handleMessage((Error)m);
                        }
                        m = null;
                    }
                    catch (Exception e) {
                        if (EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        if (!(e instanceof FatalException)) continue;
                        AbstractConnection.this.disconnect();
                    }
                }
                _thread2 = this;
                synchronized (_thread2) {
                    this.notifyAll();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class FallbackContainer {
        private Map<String[], ExportedObject> fallbacks = new HashMap<String[], ExportedObject>();

        protected FallbackContainer() {
        }

        public synchronized void add(String path, ExportedObject eo) {
            this.fallbacks.put(path.split("/"), eo);
        }

        public synchronized void remove(String path) {
            this.fallbacks.remove(path.split("/"));
        }

        public synchronized ExportedObject get(String path) {
            int best = 0;
            int i = 0;
            ExportedObject bestobject = null;
            String[] pathel = path.split("/");
            for (String[] fbpath : this.fallbacks.keySet()) {
                for (i = 0; i < pathel.length && i < fbpath.length && pathel[i].equals(fbpath[i]); ++i) {
                }
                if (i <= 0 || i != fbpath.length || i <= best) continue;
                bestobject = this.fallbacks.get(fbpath);
            }
            return bestobject;
        }
    }
}

