/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.text.MessageFormat;
import org.freedesktop.dbus.Gettext;

public class UInt16
extends Number
implements Comparable<UInt16> {
    public static final int MAX_VALUE = 65535;
    public static final int MIN_VALUE = 0;
    private int value;

    public UInt16(int value) {
        if (value < 0 || value > 65535) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), value, 0, 65535));
        }
        this.value = value;
    }

    public UInt16(String value) {
        this(Integer.parseInt(value));
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public boolean equals(Object o) {
        return o instanceof UInt16 && ((UInt16)o).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(UInt16 other) {
        return this.value - other.value;
    }

    public String toString() {
        return "" + this.value;
    }
}

