/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.util.List;
import java.util.Map;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.test.TestStruct2;

@DBus.Description(value="Test interface containing signals")
public interface TestSignalInterface
extends DBusInterface {

    public static class TestPathSignal
    extends DBusSignal {
        public final Path otherpath;
        public final List<Path> pathlist;
        public final Map<Path, Path> pathmap;

        public TestPathSignal(String path, Path otherpath, List<Path> pathlist, Map<Path, Path> pathmap) throws DBusException {
            super(path, otherpath, pathlist, pathmap);
            this.otherpath = otherpath;
            this.pathlist = pathlist;
            this.pathmap = pathmap;
        }
    }

    @DBus.Description(value="Test signal sending an object path")
    @DBusMemberName(value="TestSignalObject")
    public static class TestObjectSignal
    extends DBusSignal {
        public final DBusInterface otherpath;

        public TestObjectSignal(String path, DBusInterface otherpath) throws DBusException {
            super(path, otherpath);
            this.otherpath = otherpath;
        }
    }

    @DBus.Description(value="Test signal with arrays")
    public static class TestArraySignal
    extends DBusSignal {
        public final List<TestStruct2> v;
        public final Map<UInt32, TestStruct2> m;

        public TestArraySignal(String path, List<TestStruct2> v, Map<UInt32, TestStruct2> m) throws DBusException {
            super(path, v, m);
            this.v = v;
            this.m = m;
        }
    }

    public static class EmptySignal
    extends DBusSignal {
        public EmptySignal(String path) throws DBusException {
            super(path, new Object[0]);
        }
    }

    public static class StringSignal
    extends DBusSignal {
        public final String aoeu;

        public StringSignal(String path, String aoeu) throws DBusException {
            super(path, aoeu);
            this.aoeu = aoeu;
        }
    }

    @DBus.Description(value="Test basic signal")
    public static class TestSignal
    extends DBusSignal {
        public final String value;
        public final UInt32 number;

        public TestSignal(String path, String value, UInt32 number) throws DBusException {
            super(path, value, number);
            this.value = value;
            this.number = number;
        }
    }
}

