/*
 * Decompiled with CFR 0.152.
 */
package com.github.beothorn.html.elements;

import com.github.beothorn.html.Renderable;
import com.github.beothorn.html.common.Attribute;
import com.github.beothorn.html.common.UntaggedContent;
import com.github.beothorn.html.elements.Br;
import com.github.beothorn.html.elements.DomElement;
import com.github.beothorn.html.elements.Text;
import java.util.Arrays;
import java.util.List;

public class Page {
    public static Renderable html(DomElement ... childrenElements) {
        return new DomElement("html", childrenElements);
    }

    public static DomElement body(DomElement ... childrenElements) {
        return new DomElement("body", childrenElements);
    }

    public static DomElement b(Renderable ... childrenElements) {
        return new DomElement("b", Arrays.asList(childrenElements));
    }

    public static DomElement b(String text) {
        return new DomElement("b", Arrays.asList(Page.text(text)));
    }

    public static DomElement button(DomElement ... childrenElements) {
        return new DomElement("button", childrenElements);
    }

    public static DomElement br() {
        return new Br();
    }

    public static DomElement div(DomElement ... childrenElements) {
        return new DomElement("div", childrenElements);
    }

    public static DomElement div(List<Attribute> props, List<DomElement> childrenElements) {
        return new DomElement("div", props, childrenElements);
    }

    public static DomElement img(DomElement ... childrenElements) {
        return new DomElement("img", childrenElements);
    }

    public static DomElement img(List<Attribute> props, List<DomElement> childrenElements) {
        return new DomElement("img", props, childrenElements);
    }

    public static DomElement header(Header header, DomElement ... childrenElements) {
        return new DomElement(header.toString().toLowerCase(), childrenElements);
    }

    public static DomElement header(Header header, String title) {
        return new DomElement(header.toString().toLowerCase(), Arrays.asList(Page.text(title)));
    }

    public static DomElement h1(String title) {
        return new DomElement(Header.H1.toString().toLowerCase(), Arrays.asList(Page.text(title)).toArray(new Renderable[0]));
    }

    public static DomElement h2(String title) {
        return new DomElement(Header.H2.toString().toLowerCase(), Arrays.asList(Page.text(title)));
    }

    public static DomElement h3(String title) {
        return new DomElement(Header.H3.toString().toLowerCase(), Arrays.asList(Page.text(title)));
    }

    public static DomElement h4(String title) {
        return new DomElement(Header.H4.toString().toLowerCase(), Arrays.asList(Page.text(title)));
    }

    public static DomElement h5(String title) {
        return new DomElement(Header.H5.toString().toLowerCase(), Arrays.asList(Page.text(title)));
    }

    public static DomElement h6(String title) {
        return new DomElement(Header.H6.toString().toLowerCase(), Arrays.asList(Page.text(title)));
    }

    public static DomElement p(DomElement ... childrenElements) {
        return new DomElement("p", childrenElements);
    }

    public static DomElement p(List<Attribute> props, List<DomElement> childrenElements) {
        return new DomElement("p", props, childrenElements);
    }

    public static Text text(String content) {
        return new Text(content);
    }

    public static List<DomElement> content(DomElement ... childrenElements) {
        return Arrays.asList(childrenElements);
    }

    public static Renderable wrap(Renderable ... childrenElements) {
        return new UntaggedContent(Arrays.asList(childrenElements));
    }

    public static enum Header {
        H1,
        H2,
        H3,
        H4,
        H5,
        H6;

    }
}

