/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.commons.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import no.unit.nva.commons.json.ld.JsonLdContext;
import no.unit.nva.commons.json.ld.deserialization.JsonLdContextDeserializer;
import org.zalando.problem.jackson.ProblemModule;

public final class JsonUtils {
    private static final boolean PRETTY_JSON = true;
    public static final ObjectMapper dtoObjectMapper = JsonUtils.createJsonParser(JsonInclude.Include.NON_ABSENT, true);
    public static final ObjectMapper dynamoObjectMapper = JsonUtils.createJsonParser(JsonInclude.Include.NON_EMPTY, true);
    private static final boolean JSON_IN_SINGLE_LINE = false;
    public static final ObjectMapper singleLineObjectMapper = JsonUtils.createJsonParser(JsonInclude.Include.NON_EMPTY, false);

    private JsonUtils() {
    }

    private static ObjectMapper createJsonParser(JsonInclude.Include includeEmptyValuesOption, boolean prettyJson) {
        JsonFactory jsonFactory = new JsonFactory().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        ObjectMapper objectMapper = new ObjectMapper(jsonFactory).registerModule((Module)new ProblemModule()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)JsonUtils.emptyStringAsNullModule()).registerModule((Module)JsonUtils.jsonLdContextModule()).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setSerializationInclusion(includeEmptyValuesOption);
        return prettyJson ? objectMapper.enable(SerializationFeature.INDENT_OUTPUT) : objectMapper.disable(SerializationFeature.INDENT_OUTPUT);
    }

    private static SimpleModule jsonLdContextModule() {
        SimpleModule jsonLdContextModule = new SimpleModule();
        jsonLdContextModule.addDeserializer(JsonLdContext.class, (JsonDeserializer)new JsonLdContextDeserializer());
        return jsonLdContextModule;
    }

    private static SimpleModule emptyStringAsNullModule() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(String.class, (JsonDeserializer)new StdDeserializer<String>(String.class){

            public String deserialize(JsonParser p, DeserializationContext context) throws IOException {
                String result = StringDeserializer.instance.deserialize(p, context);
                if (result == null || result.isEmpty()) {
                    return null;
                }
                return result;
            }
        });
        return module;
    }
}

