/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.associatedartifacts.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.Instant;
import java.util.UUID;
import no.unit.nva.model.Username;
import no.unit.nva.model.associatedartifacts.file.File;
import no.unit.nva.model.associatedartifacts.file.License;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonTypeName(value="PublishedFile")
public class PublishedFile
extends File {
    public static final String TYPE = "PublishedFile";
    public static final String APPROVED_BY_USER = "approvedByUser";
    public static final String PUBLISHED_DATE = "publishedDate";
    @JsonProperty(value="approvedByUser")
    private final Username approvedByUser;
    @JsonProperty(value="publishedDate")
    private final Instant publishedDate;

    @JsonCreator
    public PublishedFile(@JsonProperty(value="identifier") UUID identifier, @JsonProperty(value="name") String name, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="size") Long size, @JsonProperty(value="license") License license, @JsonProperty(value="administrativeAgreement") boolean administrativeAgreement, @JsonProperty(value="publisherAuthority") boolean publisherAuthority, @JsonProperty(value="embargoDate") Instant embargoDate, @JsonProperty(value="approvedByUser") Username approvedByUser, @JsonProperty(value="publishedDate") Instant publishedDate) {
        super(identifier, name, mimeType, size, license, administrativeAgreement, publisherAuthority, embargoDate);
        this.approvedByUser = approvedByUser;
        this.publishedDate = publishedDate;
        if (administrativeAgreement) {
            throw new IllegalStateException("An administrative agreement is not publishable");
        }
    }

    @Override
    public boolean isVisibleForNonOwner() {
        return !this.isAdministrativeAgreement() && this.fileDoesNotHaveActiveEmbargo();
    }

    @Override
    public PublishedFile toPublishedFile() {
        return this;
    }

    public Instant getPublishedDate() {
        return this.publishedDate;
    }

    public Username getApprovedByUser() {
        return this.approvedByUser;
    }
}

