/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import no.unit.nva.WithAdditionalIdentifiers;
import no.unit.nva.WithAssociatedArtifact;
import no.unit.nva.WithContext;
import no.unit.nva.WithId;
import no.unit.nva.WithIdentifier;
import no.unit.nva.WithInternal;
import no.unit.nva.WithMetadata;
import no.unit.nva.api.PublicationContext;
import no.unit.nva.identifiers.SortableIdentifier;
import no.unit.nva.model.AdditionalIdentifier;
import no.unit.nva.model.EntityDescription;
import no.unit.nva.model.ImportDetail;
import no.unit.nva.model.Organization;
import no.unit.nva.model.Publication;
import no.unit.nva.model.PublicationOperation;
import no.unit.nva.model.PublicationStatus;
import no.unit.nva.model.ResearchProject;
import no.unit.nva.model.ResourceOwner;
import no.unit.nva.model.associatedartifacts.AssociatedArtifactList;
import no.unit.nva.model.funding.Funding;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonTypeName(value="Publication")
public class PublicationResponse
implements WithIdentifier,
WithInternal,
WithMetadata,
WithAssociatedArtifact,
WithId,
WithContext,
WithAdditionalIdentifiers {
    private SortableIdentifier identifier;
    private PublicationStatus status;
    private ResourceOwner resourceOwner;
    private Organization publisher;
    private Instant createdDate;
    private Instant modifiedDate;
    private Instant publishedDate;
    private Instant indexedDate;
    private URI handle;
    private URI link;
    private EntityDescription entityDescription;
    private URI doi;
    @JsonProperty(value="@context")
    private JsonNode context;
    private List<ResearchProject> projects;
    private List<Funding> fundings;
    private List<URI> subjects;
    private AssociatedArtifactList associatedArtifacts;
    private List<ImportDetail> importDetails;
    private Set<AdditionalIdentifier> additionalIdentifiers;
    private String rightsHolder;
    private Set<PublicationOperation> allowedOperations;
    private URI duplicateOf;

    public static PublicationResponse fromPublication(Publication publication) {
        PublicationResponse response = new PublicationResponse();
        response.setIdentifier(publication.getIdentifier());
        response.setStatus(publication.getStatus());
        response.setDuplicateOf(publication.getDuplicateOf());
        response.setResourceOwner(publication.getResourceOwner());
        response.setPublisher(publication.getPublisher());
        response.setCreatedDate(publication.getCreatedDate());
        response.setModifiedDate(publication.getModifiedDate());
        response.setPublishedDate(publication.getPublishedDate());
        response.setIndexedDate(publication.getIndexedDate());
        response.setHandle(publication.getHandle());
        response.setLink(publication.getLink());
        response.setEntityDescription(publication.getEntityDescription());
        response.setAssociatedArtifacts(publication.getAssociatedArtifacts());
        response.setDoi(publication.getDoi());
        response.setProjects(publication.getProjects());
        response.setFundings(publication.getFundings());
        response.setSubjects(publication.getSubjects());
        response.setContext(PublicationContext.getContext(publication));
        response.setAssociatedArtifacts(publication.getAssociatedArtifacts());
        response.setAdditionalIdentifiers(publication.getAdditionalIdentifiers());
        response.setRightsHolder(publication.getRightsHolder());
        response.setAllowedOperations(Set.of());
        response.setImportDetails(publication.getImportDetails());
        return response;
    }

    public static PublicationResponse fromPublicationWithAllowedOperations(Publication publication, Set<PublicationOperation> allowedOperations) {
        PublicationResponse response = PublicationResponse.fromPublication(publication);
        response.setAllowedOperations(allowedOperations);
        return response;
    }

    public void setDuplicateOf(URI duplicateOf) {
        this.duplicateOf = duplicateOf;
    }

    public URI getDuplicateOf() {
        return this.duplicateOf;
    }

    @Override
    public SortableIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(SortableIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public Instant getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    @Override
    public PublicationStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(PublicationStatus status) {
        this.status = status;
    }

    @Override
    public URI getHandle() {
        return this.handle;
    }

    @Override
    public void setHandle(URI handle) {
        this.handle = handle;
    }

    @Override
    public Instant getPublishedDate() {
        return this.publishedDate;
    }

    @Override
    public void setPublishedDate(Instant publishedDate) {
        this.publishedDate = publishedDate;
    }

    @Override
    public Instant getModifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public void setModifiedDate(Instant modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Override
    public ResourceOwner getResourceOwner() {
        return this.resourceOwner;
    }

    @Override
    public void setResourceOwner(ResourceOwner resourceOwner) {
        this.resourceOwner = resourceOwner;
    }

    @Override
    public Instant getIndexedDate() {
        return this.indexedDate;
    }

    @Override
    public void setIndexedDate(Instant indexedDate) {
        this.indexedDate = indexedDate;
    }

    @Override
    public URI getLink() {
        return this.link;
    }

    @Override
    public void setLink(URI link) {
        this.link = link;
    }

    @Override
    public Organization getPublisher() {
        return this.publisher;
    }

    @Override
    public void setPublisher(Organization publisher) {
        this.publisher = publisher;
    }

    @Override
    public URI getDoi() {
        return this.doi;
    }

    @Override
    public void setDoi(URI doi) {
        this.doi = doi;
    }

    @Override
    public EntityDescription getEntityDescription() {
        return this.entityDescription;
    }

    @Override
    public void setEntityDescription(EntityDescription entityDescription) {
        this.entityDescription = entityDescription;
    }

    @Override
    public List<ResearchProject> getProjects() {
        return Objects.nonNull(this.projects) ? this.projects : Collections.emptyList();
    }

    @Override
    public void setProjects(List<ResearchProject> projects) {
        this.projects = projects;
    }

    @Override
    public List<URI> getSubjects() {
        return Objects.nonNull(this.subjects) ? this.subjects : Collections.emptyList();
    }

    @Override
    public void setSubjects(List<URI> subjects) {
        this.subjects = subjects;
    }

    @Override
    public List<Funding> getFundings() {
        return this.fundings;
    }

    @Override
    public void setFundings(List<Funding> fundings) {
        this.fundings = fundings;
    }

    @Override
    public String getRightsHolder() {
        return this.rightsHolder;
    }

    @Override
    public void setRightsHolder(String rightsHolder) {
        this.rightsHolder = rightsHolder;
    }

    @Override
    public JsonNode getContext() {
        return this.context;
    }

    @Override
    public void setContext(JsonNode context) {
        this.context = context;
    }

    @Override
    public AssociatedArtifactList getAssociatedArtifacts() {
        return this.associatedArtifacts;
    }

    @Override
    public void setAssociatedArtifacts(AssociatedArtifactList associatedArtifacts) {
        this.associatedArtifacts = associatedArtifacts;
    }

    @Override
    public List<ImportDetail> getImportDetails() {
        return this.importDetails;
    }

    @Override
    public void setImportDetails(Collection<ImportDetail> importDetails) {
        this.importDetails = new ArrayList<ImportDetail>(importDetails);
    }

    @Override
    public Set<AdditionalIdentifier> getAdditionalIdentifiers() {
        return this.additionalIdentifiers;
    }

    @Override
    public void setAdditionalIdentifiers(Set<AdditionalIdentifier> additionalIdentifiers) {
        this.additionalIdentifiers = additionalIdentifiers;
    }

    public Set<PublicationOperation> getAllowedOperations() {
        return this.allowedOperations;
    }

    public void setAllowedOperations(Set<PublicationOperation> allowedOperations) {
        this.allowedOperations = allowedOperations;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getIdentifier(), this.getStatus(), this.getDuplicateOf(), this.getResourceOwner(), this.getPublisher(), this.getCreatedDate(), this.getModifiedDate(), this.getPublishedDate(), this.getIndexedDate(), this.getHandle(), this.getLink(), this.getEntityDescription(), this.getDoi(), this.getContext(), this.getProjects(), this.getFundings(), this.getSubjects(), this.getAdditionalIdentifiers(), this.getAssociatedArtifacts(), this.getRightsHolder(), this.getAllowedOperations(), this.getImportDetails()});
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicationResponse)) {
            return false;
        }
        PublicationResponse that = (PublicationResponse)o;
        return Objects.equals(this.getIdentifier(), that.getIdentifier()) && this.getStatus() == that.getStatus() && Objects.equals(this.getDuplicateOf(), that.getDuplicateOf()) && Objects.equals(this.getResourceOwner(), that.getResourceOwner()) && Objects.equals(this.getPublisher(), that.getPublisher()) && Objects.equals(this.getCreatedDate(), that.getCreatedDate()) && Objects.equals(this.getModifiedDate(), that.getModifiedDate()) && Objects.equals(this.getPublishedDate(), that.getPublishedDate()) && Objects.equals(this.getIndexedDate(), that.getIndexedDate()) && Objects.equals(this.getHandle(), that.getHandle()) && Objects.equals(this.getLink(), that.getLink()) && Objects.equals(this.getEntityDescription(), that.getEntityDescription()) && Objects.equals(this.getDoi(), that.getDoi()) && Objects.equals(this.getContext(), that.getContext()) && Objects.equals(this.getProjects(), that.getProjects()) && Objects.equals(this.getFundings(), that.getFundings()) && Objects.equals(this.getSubjects(), that.getSubjects()) && Objects.equals(this.getAdditionalIdentifiers(), that.getAdditionalIdentifiers()) && Objects.equals(this.getAssociatedArtifacts(), that.getAssociatedArtifacts()) && Objects.equals(this.getRightsHolder(), that.getRightsHolder()) && Objects.equals(this.getAllowedOperations(), that.getAllowedOperations()) && Objects.equals(this.getImportDetails(), that.getImportDetails());
    }
}

