/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.associatedartifacts.file;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;
import no.unit.nva.model.Revision;

public enum PublisherVersion {
    PUBLISHED_VERSION("PublishedVersion"),
    ACCEPTED_VERSION("AcceptedVersion");

    public static final String ERROR_MESSAGE_TEMPLATE = "%s not a valid PublisherVersion, expected one of: %s";
    public static final String DELIMITER = ", ";
    private final String value;

    private PublisherVersion(String value) {
        this.value = value;
    }

    public static PublisherVersion parse(String value) {
        return Arrays.stream(PublisherVersion.values()).filter(revision -> revision.getValue().equalsIgnoreCase(value)).findAny().orElseThrow(() -> PublisherVersion.throwIllegalArgumentException(value));
    }

    private static IllegalArgumentException throwIllegalArgumentException(String value) {
        return new IllegalArgumentException(String.format(ERROR_MESSAGE_TEMPLATE, value, Arrays.stream(Revision.values()).map(Enum::toString).collect(Collectors.joining(DELIMITER))));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

