/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import no.unit.nva.model.contexttypes.PublicationContext;
import no.unit.nva.model.contexttypes.media.MediaFormat;
import no.unit.nva.model.contexttypes.media.MediaSubType;
import no.unit.nva.model.contexttypes.media.SeriesEpisode;
import nva.commons.core.JacocoGenerated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class MediaContribution
implements PublicationContext {
    private static final String MEDIUM = "medium";
    private static final String FORMAT = "format";
    private static final String DISSEMINATION_CHANNEL = "disseminationChannel";
    private static final String PART_OF = "partOf";
    @JsonProperty(value="medium")
    private final MediaSubType medium;
    @JsonProperty(value="format")
    private final MediaFormat format;
    @JsonProperty(value="disseminationChannel")
    private final String disseminationChannel;
    @JsonProperty(value="partOf")
    private final SeriesEpisode partOf;

    public MediaContribution(@JsonProperty(value="medium") MediaSubType medium, @JsonProperty(value="format") MediaFormat format, @JsonProperty(value="disseminationChannel") String disseminationChannel, @JsonProperty(value="partOf") SeriesEpisode partOf) {
        this.medium = medium;
        this.format = format;
        this.disseminationChannel = disseminationChannel;
        this.partOf = partOf;
    }

    public MediaSubType getMedium() {
        return this.medium;
    }

    public MediaFormat getFormat() {
        return this.format;
    }

    public String getDisseminationChannel() {
        return this.disseminationChannel;
    }

    public SeriesEpisode getPartOf() {
        return this.partOf;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaContribution)) {
            return false;
        }
        MediaContribution that = (MediaContribution)o;
        return Objects.equals(this.getMedium(), that.getMedium()) && this.getFormat() == that.getFormat() && Objects.equals(this.getDisseminationChannel(), that.getDisseminationChannel()) && Objects.equals(this.getPartOf(), that.getPartOf());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.getMedium(), this.getFormat(), this.getDisseminationChannel(), this.getPartOf()});
    }

    public static final class Builder {
        private MediaSubType medium;
        private MediaFormat format;
        private String disseminationChannel;
        private SeriesEpisode partOf;

        public Builder withMedium(MediaSubType medium) {
            this.medium = medium;
            return this;
        }

        public Builder withFormat(MediaFormat format) {
            this.format = format;
            return this;
        }

        public Builder withDisseminationChannel(String disseminationChannel) {
            this.disseminationChannel = disseminationChannel;
            return this;
        }

        public Builder withPartOf(SeriesEpisode partOf) {
            this.partOf = partOf;
            return this;
        }

        public MediaContribution build() {
            return new MediaContribution(this.medium, this.format, this.disseminationChannel, this.partOf);
        }
    }
}

