/*
 * Decompiled with CFR 0.152.
 */
package com.bld.proxy.api.find.config;

import bld.commons.service.JpaService;
import com.bld.proxy.api.find.annotations.ApiFind;
import com.bld.proxy.api.find.annotations.ApiFindController;
import com.bld.proxy.api.find.annotations.ApiMapper;
import com.bld.proxy.api.find.config.annotation.EnableProxyApiController;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public class ApiFindRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
ResourceLoaderAware,
ApplicationContextAware {
    private static final String PROXY_CONFIG = "proxyConfig";
    private static final String NEW_PROXY_INSTANCE = "newProxyInstance";
    private Environment env;
    private ResourceLoader resourceLoader;
    private static final Logger logger = LoggerFactory.getLogger(ApiFindRegistrar.class);
    private ApplicationContext applicationContext;
    private static AnnotationMetadata metadata;
    private static BeanDefinitionRegistry registry;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        ApiFindRegistrar.metadata = metadata;
        ApiFindRegistrar.registry = registry;
    }

    private void addBeanDefinitions() {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        LinkedHashSet candidateComponents = new LinkedHashSet();
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ApiFindController.class));
        Set<String> baseProjects = this.getBasePackages(metadata);
        for (String baseProject : baseProjects) {
            logger.debug("package: " + baseProject);
            candidateComponents.addAll(scanner.findCandidateComponents(baseProject));
            try {
                for (BeanDefinition candidate : candidateComponents) {
                    HashMap<String, Object> mapBean = new HashMap<String, Object>();
                    String beanClassName = candidate.getBeanClassName();
                    Class<?> classApiController = Class.forName(beanClassName);
                    ApiFind apiFind = classApiController.getAnnotation(ApiFind.class);
                    ApiMapper apiMapper = classApiController.getAnnotation(ApiMapper.class);
                    this.addBean(mapBean, apiFind, apiMapper);
                    BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(classApiController);
                    builder.setFactoryMethodOnBean(NEW_PROXY_INSTANCE, PROXY_CONFIG);
                    builder.addConstructorArgValue(classApiController);
                    builder.addConstructorArgValue((Object)this.applicationContext);
                    builder.addConstructorArgValue(mapBean);
                    AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
                    registry.registerBeanDefinition(classApiController.getName(), (BeanDefinition)beanDefinition);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.env){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableProxyApiController.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.addBeanDefinitions();
    }

    private void addBean(Map<String, Object> mapBean, ApiFind apiFind, ApiMapper apiMapper) {
        if (apiFind != null) {
            this.apiFind(mapBean, apiFind);
        }
        if (apiMapper != null) {
            this.apiMapper(mapBean, apiMapper);
        }
    }

    private void apiMapper(Map<String, Object> mapBean, ApiMapper apiMapper) {
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            try {
                Class<?>[] interfaces;
                Object mapper = this.applicationContext.getBean(beanName);
                Class<?> mapperClass = mapper.getClass();
                do {
                    if (!mapperClass.getName().equals(apiMapper.value().getName())) continue;
                    mapBean.put(apiMapper.value().getName(), mapper);
                    return;
                } while ((mapperClass = mapperClass.getSuperclass()) != null && !Object.class.getName().equals(mapperClass.getName()));
                for (Class<?> intrf : interfaces = mapperClass.getInterfaces()) {
                    if (!intrf.getClass().getName().equals(apiMapper.value().getName())) continue;
                    mapBean.put(apiMapper.value().getName(), mapper);
                    return;
                }
            }
            catch (BeansException e) {
                logger.warn("Bean " + beanName + " ignored for @ApiController");
            }
        }
    }

    private void apiFind(Map<String, Object> mapBean, ApiFind apiFind) {
        String[] beanNames;
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForType(JpaService.class)) {
            Class[] typeArguments = ResolvableType.forType((Type)this.applicationContext.getType(beanName)).as(JpaService.class).resolveGenerics();
            if (!typeArguments[0].getName().equals(apiFind.entity().getName()) || !apiFind.id().getName().equals(typeArguments[1].getName())) continue;
            JpaService jpaService = (JpaService)this.applicationContext.getBean(beanName);
            mapBean.put(apiFind.entity().getName() + " " + apiFind.id().getName(), jpaService);
            return;
        }
    }
}

