/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.apt;

import com.github.braisdom.objsql.apt.APTBuilder;
import com.github.braisdom.objsql.apt.AnnotationValues;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Names;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public abstract class DomainModelProcessor
extends AbstractProcessor {
    private Messager messager;
    private Elements elementUtils;
    private JavacTrees javacTrees;
    private TreeMaker treeMaker;
    private Names names;
    private ClassLoader classloader;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.classloader = ClassLoader.getSystemClassLoader();
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        this.javacTrees = JavacTrees.instance(processingEnv);
        Context context = ((JavacProcessingEnvironment)processingEnv).getContext();
        this.treeMaker = TreeMaker.instance(context);
        this.names = Names.instance(context);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Class<? extends Annotation> annotationClass = this.getAnnotationClass();
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(annotationClass);
        for (Element element : elements) {
            JCTree ast = this.javacTrees.getTree(element);
            JCTree.JCClassDecl classDecl = ast instanceof JCTree.JCClassDecl ? (JCTree.JCClassDecl)ast : (ast instanceof JCTree.JCVariableDecl ? this.getClassDecl((JCTree.JCVariableDecl)ast) : (ast instanceof JCTree.JCMethodDecl ? this.getClassDecl((JCTree.JCMethodDecl)ast) : null));
            APTBuilder aptBuilder = new APTBuilder(classDecl, element, ast, this.treeMaker, this.names, this.messager);
            this.handle(new AnnotationValues(ast, this.classloader), ast, aptBuilder);
        }
        return true;
    }

    private JCTree.JCClassDecl getClassDecl(JCTree.JCVariableDecl tree) {
        String className = tree.sym.owner.getQualifiedName().toString();
        TypeElement typeElement = this.elementUtils.getTypeElement(className);
        return this.javacTrees.getTree(typeElement);
    }

    private JCTree.JCClassDecl getClassDecl(JCTree.JCMethodDecl tree) {
        String className = tree.sym.owner.getQualifiedName().toString();
        TypeElement typeElement = this.elementUtils.getTypeElement(className);
        return this.javacTrees.getTree(typeElement);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedOptions = new HashSet<String>();
        supportedOptions.add(this.getAnnotationClass().getCanonicalName());
        return supportedOptions;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    protected abstract Class<? extends Annotation> getAnnotationClass();

    protected abstract void handle(AnnotationValues var1, JCTree var2, APTBuilder var3);
}

