/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class QueryLoader {
    private static final QueryLoader instance = new QueryLoader();
    private static final Pattern dotXml = Pattern.compile(".+\\.[xX][mM][lL]");
    private final Map<String, Map<String, String>> queries = new HashMap<String, Map<String, String>>();

    public static QueryLoader instance() {
        return instance;
    }

    protected QueryLoader() {
    }

    public synchronized Map<String, String> load(String path) throws IOException {
        Map<String, String> queryMap = this.queries.get(path);
        if (queryMap == null) {
            queryMap = this.loadQueries(path);
            this.queries.put(path, queryMap);
        }
        return queryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> loadQueries(String path) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(path);
        if (in == null) {
            throw new IllegalArgumentException(path + " not found.");
        }
        Properties props = new Properties();
        try {
            if (dotXml.matcher(path).matches()) {
                props.loadFromXML(in);
            } else {
                props.load(in);
            }
        }
        finally {
            in.close();
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(props);
        return hashMap;
    }

    public synchronized void unload(String path) {
        this.queries.remove(path);
    }
}

