/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql;

import com.github.braisdom.objsql.DomainModelDescriptor;
import com.github.braisdom.objsql.DomainModelException;
import com.github.braisdom.objsql.Tables;
import com.github.braisdom.objsql.annotations.Column;
import com.github.braisdom.objsql.annotations.DomainModel;
import com.github.braisdom.objsql.annotations.PrimaryKey;
import com.github.braisdom.objsql.annotations.Transient;
import com.github.braisdom.objsql.reflection.ClassUtils;
import com.github.braisdom.objsql.reflection.PropertyUtils;
import com.github.braisdom.objsql.transition.ColumnTransitional;
import com.github.braisdom.objsql.util.StringUtil;
import com.github.braisdom.objsql.util.WordUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BeanModelDescriptor<T>
implements DomainModelDescriptor<T> {
    private static final List<Class> COLUMNIZABLE_FIELD_TYPES = Arrays.asList(String.class, Character.TYPE, Long.class, Long.TYPE, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE);
    private final Class<T> domainModelClass;
    private final Map<String, ColumnTransitional> columnTransitionMap;
    private final Map<String, Field> columnToField;

    public BeanModelDescriptor(Class<T> domainModelClass) {
        Objects.requireNonNull(domainModelClass, "The domainModelClass cannot be null");
        if (Tables.getPrimaryKey(domainModelClass) == null) {
            throw new DomainModelException(String.format("The %s has no primary key", domainModelClass.getSimpleName()));
        }
        this.domainModelClass = domainModelClass;
        this.columnTransitionMap = new HashMap<String, ColumnTransitional>();
        this.columnToField = new HashMap<String, Field>();
        this.prepareColumnToPropertyOverrides(domainModelClass);
        this.instantiateColumnTransitionMap(domainModelClass.getDeclaredFields());
    }

    @Override
    public T newInstance() {
        return ClassUtils.createNewInstance(this.domainModelClass);
    }

    @Override
    public Class getDomainModelClass() {
        return this.domainModelClass;
    }

    @Override
    public DomainModelDescriptor getRelatedModeDescriptor(Class relatedClass) {
        return new BeanModelDescriptor<T>(relatedClass);
    }

    @Override
    public String[] getColumns() {
        return (String[])Arrays.stream(this.getColumnizableFields(this.domainModelClass, true, true)).map(field -> this.getColumnName((Field)field)).toArray(String[]::new);
    }

    @Override
    public String getTableName() {
        return Tables.getTableName(this.domainModelClass);
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return Tables.getPrimaryKey(this.domainModelClass);
    }

    @Override
    public Object getPrimaryValue(Object domainObject) {
        return PropertyUtils.readDirectly(domainObject, this.getPrimaryKey().name());
    }

    @Override
    public boolean skipNullOnUpdate() {
        return this.domainModelClass.getAnnotation(DomainModel.class).skipNullValueOnUpdating();
    }

    @Override
    public String[] getInsertableColumns() {
        return (String[])Arrays.stream(this.getColumnizableFields(this.domainModelClass, true, false)).map(field -> this.getColumnName((Field)field)).toArray(String[]::new);
    }

    @Override
    public String[] getUpdatableColumns() {
        return (String[])Arrays.stream(this.getColumnizableFields(this.domainModelClass, false, true)).filter(field -> field.getAnnotation(PrimaryKey.class) == null).map(field -> this.getColumnName((Field)field)).toArray(String[]::new);
    }

    @Override
    public String getColumnName(String fieldName) {
        return null;
    }

    @Override
    public String getFieldName(String fieldName) {
        Field field = this.columnToField.get(fieldName);
        return field == null ? null : field.getName();
    }

    @Override
    public Class getFieldType(String fieldName) {
        try {
            return this.domainModelClass.getDeclaredField(fieldName).getType();
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    @Override
    public Object getValue(T modelObject, String fieldName) {
        return PropertyUtils.readDirectly(modelObject, fieldName);
    }

    @Override
    public void setValue(T modelObject, String fieldName, Object fieldValue) {
        PropertyUtils.writeDirectly(modelObject, fieldName, fieldValue);
    }

    @Override
    public ColumnTransitional getColumnTransition(String fieldName) {
        return this.columnTransitionMap.get(fieldName);
    }

    protected Field[] getColumnizableFields(Class domainModelClass, boolean insertable, boolean updatable) {
        DomainModel domainModel = domainModelClass.getAnnotation(DomainModel.class);
        Field primaryField = Tables.getPrimaryField(domainModelClass);
        Field[] fields = domainModelClass.getDeclaredFields();
        if (domainModel.allFieldsPersistent()) {
            return (Field[])Arrays.stream(fields).filter(field -> {
                Column column = field.getAnnotation(Column.class);
                Transient transientAnnotation = field.getAnnotation(Transient.class);
                if (!Modifier.isStatic(field.getModifiers()) && transientAnnotation == null) {
                    if (column == null) {
                        return this.isColumnizable((Field)field);
                    }
                    return this.ensureColumnizable(column, (Field)field, primaryField, insertable, updatable);
                }
                return false;
            }).toArray(Field[]::new);
        }
        return (Field[])Arrays.stream(fields).filter(field -> {
            Column column = field.getAnnotation(Column.class);
            Transient transientAnnotation = field.getAnnotation(Transient.class);
            if (!Modifier.isStatic(field.getModifiers()) && transientAnnotation == null) {
                if (column == null) {
                    return false;
                }
                return this.ensureColumnizable(column, (Field)field, primaryField, insertable, updatable);
            }
            return false;
        }).toArray(Field[]::new);
    }

    protected String getColumnName(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column != null && !StringUtil.isBlank(column.name())) {
            return column.name();
        }
        return WordUtil.underscore(field.getName());
    }

    protected boolean isColumnizable(Field field) {
        return COLUMNIZABLE_FIELD_TYPES.contains(field.getType());
    }

    private boolean ensureColumnizable(Column column, Field field, Field primaryField, boolean insertable, boolean updatable) {
        if (insertable && updatable) {
            return true;
        }
        if (insertable) {
            return column.insertable();
        }
        if (updatable) {
            return updatable && column.updatable() && !field.equals(primaryField);
        }
        return false;
    }

    private void prepareColumnToPropertyOverrides(Class<T> rowClass) {
        Field[] fields = rowClass.getDeclaredFields();
        Arrays.stream(fields).forEach(field -> {
            PrimaryKey primaryKey = field.getAnnotation(PrimaryKey.class);
            Column column = field.getAnnotation(Column.class);
            if (primaryKey != null) {
                String columnName = StringUtil.isBlank(primaryKey.name()) ? WordUtil.underscore(field.getName()) : primaryKey.name();
                this.columnToField.put(columnName, (Field)field);
            } else if (column != null) {
                String columnName = StringUtil.isBlank(column.name()) ? WordUtil.underscore(field.getName()) : primaryKey.name();
                this.columnToField.put(columnName, (Field)field);
            } else {
                this.columnToField.put(WordUtil.underscore(field.getName()), (Field)field);
            }
        });
    }

    private Map<String, ColumnTransitional> instantiateColumnTransitionMap(Field[] fields) {
        Arrays.stream(fields).forEach(field -> {
            Column column = field.getAnnotation(Column.class);
            if (column != null && !column.transition().equals(ColumnTransitional.class)) {
                this.columnTransitionMap.put(field.getName(), ClassUtils.createNewInstance(column.transition()));
            }
        });
        return this.columnTransitionMap;
    }
}

