/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql;

import com.github.braisdom.objsql.Databases;
import com.github.braisdom.objsql.DomainModelDescriptor;
import com.github.braisdom.objsql.DomainModelHandler;
import com.github.braisdom.objsql.DomainModelListHandler;
import com.github.braisdom.objsql.Logger;
import com.github.braisdom.objsql.SQLExecutor;
import com.github.braisdom.objsql.jdbc.QueryRunner;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class DefaultSQLExecutor<T>
implements SQLExecutor<T> {
    private static final Logger logger = Databases.getLoggerFactory().create(DefaultSQLExecutor.class);
    private final QueryRunner queryRunner = new QueryRunner();

    @Override
    public List<T> query(Connection connection, String sql, DomainModelDescriptor domainModelDescriptor, Object ... params) throws SQLException {
        return Databases.sqlBenchmarking(() -> this.queryRunner.query(connection, sql, new DomainModelListHandler(domainModelDescriptor, connection.getMetaData()), params), logger, sql, params);
    }

    @Override
    public T insert(Connection connection, String sql, DomainModelDescriptor domainModelDescriptor, Object ... params) throws SQLException {
        return (T)Databases.sqlBenchmarking(() -> this.queryRunner.insert(connection, sql, new DomainModelHandler(domainModelDescriptor, connection.getMetaData()), params), logger, sql, params);
    }

    @Override
    public int[] insert(Connection connection, String sql, DomainModelDescriptor domainModelDescriptor, Object[][] params) throws SQLException {
        return Databases.sqlBenchmarking(() -> this.queryRunner.insertBatch(connection, sql, params), logger, sql, (Object[])params);
    }

    @Override
    public int execute(Connection connection, String sql, Object ... params) throws SQLException {
        return Databases.sqlBenchmarking(() -> this.queryRunner.update(connection, sql, params), logger, sql, params);
    }
}

