/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql;

import com.github.braisdom.objsql.AbstractResultSetHandler;
import com.github.braisdom.objsql.DomainModelDescriptor;
import com.github.braisdom.objsql.reflection.PropertyUtils;
import com.github.braisdom.objsql.transition.ColumnTransitional;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class DomainModelListHandler
extends AbstractResultSetHandler<List> {
    private final DomainModelDescriptor domainModelDescriptor;
    private final DatabaseMetaData databaseMetaData;

    public DomainModelListHandler(DomainModelDescriptor domainModelDescriptor, DatabaseMetaData databaseMetaData) {
        this.domainModelDescriptor = domainModelDescriptor;
        this.databaseMetaData = databaseMetaData;
    }

    @Override
    public List handle(ResultSet rs) throws SQLException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (!rs.next()) {
            return results;
        }
        do {
            results.add(this.createBean(rs));
        } while (rs.next());
        return results;
    }

    private Object createBean(ResultSet rs) throws SQLException {
        Object bean = this.domainModelDescriptor.newInstance();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = metaData.getColumnName(i);
            String fieldName = this.domainModelDescriptor.getFieldName(columnName);
            if (fieldName != null) {
                Class fieldType = this.domainModelDescriptor.getFieldType(fieldName);
                ColumnTransitional columnTransitional = this.domainModelDescriptor.getColumnTransition(fieldName);
                Object rawValue = this.getValue(fieldType, rs.getObject(columnName));
                Object value = columnTransitional == null ? rawValue : columnTransitional.rising(this.databaseMetaData, metaData, bean, this.domainModelDescriptor, fieldName, rawValue);
                this.domainModelDescriptor.setValue(bean, fieldName, value);
                continue;
            }
            PropertyUtils.writeRawAttribute(bean, columnName, rs.getObject(columnName));
        }
        return bean;
    }
}

