/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.apt;

import com.github.braisdom.objsql.apt.APTBuilder;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;

public class MethodBuilder {
    private final TreeMaker treeMaker;
    private final APTBuilder aptBuilder;
    private final ListBuffer<JCTree.JCVariableDecl> parameters;
    private final ListBuffer<JCTree.JCStatement> statements;
    private JCTree.JCExpression returnType;
    private ListBuffer<JCTree.JCExpression> throwsClauses;
    private JCTree.JCExpression returnStatement;

    MethodBuilder(APTBuilder aptBuilder) {
        this.treeMaker = aptBuilder.getTreeMaker();
        this.aptBuilder = aptBuilder;
        this.parameters = new ListBuffer();
        this.statements = new ListBuffer();
        this.throwsClauses = new ListBuffer();
    }

    public MethodBuilder setThrowsClauses(Class<? extends Throwable> ... throwsClauseArray) {
        for (Class<? extends Throwable> throwsClause : throwsClauseArray) {
            this.throwsClauses.append(this.aptBuilder.typeRef(throwsClause.getName()));
        }
        return this;
    }

    public MethodBuilder addThrowsClauses(JCTree.JCExpression throwExpression) {
        this.throwsClauses.append(throwExpression);
        return this;
    }

    public MethodBuilder setReturnType(Class<?> typeClass, Class<?> ... genTypeClass) {
        JCTree.JCExpression[] genTypes = (JCTree.JCExpression[])Arrays.stream(genTypeClass).map(exceptionClass -> this.treeMaker.Throw(this.aptBuilder.typeRef(exceptionClass.getName())).getExpression()).toArray(JCTree.JCExpression[]::new);
        this.returnType = this.treeMaker.TypeApply(this.aptBuilder.typeRef(typeClass), List.from(genTypes));
        return this;
    }

    public MethodBuilder setReturnType(Class<?> typeClass, JCTree.JCExpression ... genTypeClass) {
        this.returnType = this.treeMaker.TypeApply(this.aptBuilder.typeRef(typeClass), List.from(genTypeClass));
        return this;
    }

    public MethodBuilder setReturnType(JCTree.JCExpression type, JCTree.JCExpression ... genType) {
        this.returnType = this.treeMaker.TypeApply(type, List.from(genType));
        return this;
    }

    public MethodBuilder setReturnType(JCTree.JCExpression type) {
        this.returnType = type;
        return this;
    }

    public MethodBuilder setReturnStatement(String varName, String methodName, JCTree.JCExpression ... params) {
        JCTree.JCFieldAccess methodRef = this.treeMaker.Select(this.aptBuilder.varRef(varName), this.aptBuilder.toName(methodName));
        this.returnStatement = this.treeMaker.Apply(List.nil(), methodRef, List.from(params));
        return this;
    }

    public MethodBuilder setReturnStatement(Class clazz, String methodName, JCTree.JCExpression ... params) {
        JCTree.JCFieldAccess methodRef = this.treeMaker.Select(this.aptBuilder.typeRef(clazz), this.aptBuilder.toName(methodName));
        this.returnStatement = this.treeMaker.Apply(List.nil(), methodRef, List.from(params));
        return this;
    }

    public MethodBuilder setReturnStatement(JCTree.JCExpression returnStatement) {
        this.returnStatement = returnStatement;
        return this;
    }

    public MethodBuilder addStatements(List<JCTree.JCStatement> newStatement) {
        this.statements.appendList(newStatement);
        return this;
    }

    public MethodBuilder addStatement(JCTree.JCStatement statement) {
        this.statements.append(statement);
        return this;
    }

    public MethodBuilder addParameter(JCTree.JCVariableDecl ... parameters) {
        this.parameters.appendList(List.from(parameters));
        return this;
    }

    public MethodBuilder addParameter(String name, JCTree.JCExpression type, JCTree.JCExpression ... genTypes) {
        this.addParameter(name, type, List.from(genTypes));
        return this;
    }

    public MethodBuilder addParameter(String name, JCTree.JCExpression type, List<JCTree.JCExpression> genTypes) {
        if (genTypes.size() > 0) {
            JCTree.JCTypeApply typeApply = this.treeMaker.TypeApply(type, genTypes);
            this.addParameter(name, (JCTree.JCExpression)typeApply);
        } else {
            this.addParameter(name, type);
        }
        return this;
    }

    public MethodBuilder addParameter(String name, Class<?> clazz) {
        this.addParameter(this.aptBuilder.toName(name), clazz);
        return this;
    }

    public MethodBuilder addParameter(Name name, Class<?> clazz) {
        this.addParameter(name, this.aptBuilder.typeRef(clazz));
        return this;
    }

    public MethodBuilder addParameter(String name, JCTree.JCExpression type) {
        this.addParameter(this.aptBuilder.toName(name), type);
        return this;
    }

    public MethodBuilder addParameter(Name name, JCTree.JCExpression type) {
        this.treeMaker.at(this.aptBuilder.get().pos);
        this.parameters.add(this.treeMaker.VarDef(this.treeMaker.Modifiers(0x200000000L), name, type, null));
        return this;
    }

    public MethodBuilder addArrayParameter(String name, Class<?> clazz) {
        this.addParameter(this.aptBuilder.toName(name), this.aptBuilder.newArrayType(clazz));
        return this;
    }

    public MethodBuilder addVarargsParameter(String name, Class typeClass) {
        this.addVarargsParameter(this.aptBuilder.toName(name), this.aptBuilder.typeRef(typeClass));
        return this;
    }

    public MethodBuilder addVarargsParameter(String name, JCTree.JCExpression type) {
        this.addVarargsParameter(this.aptBuilder.toName(name), type);
        return this;
    }

    public MethodBuilder addVarargsParameter(Name name, JCTree.JCExpression type) {
        this.treeMaker.at(this.aptBuilder.get().pos);
        this.parameters.add(this.treeMaker.VarDef(this.treeMaker.Modifiers(0x600000000L), name, this.treeMaker.TypeArray(type), null));
        return this;
    }

    public JCTree.JCMethodDecl build(String name, int modifiers) {
        if (this.returnType == null) {
            this.returnType = this.treeMaker.TypeIdent(TypeTag.VOID);
        }
        if (this.returnStatement != null) {
            this.statements.append(this.treeMaker.Return(this.returnStatement));
        }
        return this.treeMaker.MethodDef(this.treeMaker.Modifiers(modifiers), this.aptBuilder.toName(name), this.returnType, List.nil(), this.parameters.toList(), this.throwsClauses.toList(), this.treeMaker.Block(0L, this.statements.toList()), null);
    }
}

