/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;

public final class DbUtils {
    public static void close(Connection conn) throws SQLException {
        if (conn != null) {
            conn.close();
        }
    }

    public static void close(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }

    public static void close(Statement stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
    }

    public static void closeQuietly(Connection conn) {
        try {
            DbUtils.close(conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeQuietly(Connection conn, Statement stmt, ResultSet rs) {
        try {
            DbUtils.closeQuietly(rs);
        }
        finally {
            try {
                DbUtils.closeQuietly(stmt);
            }
            finally {
                DbUtils.closeQuietly(conn);
            }
        }
    }

    public static void closeQuietly(ResultSet rs) {
        try {
            DbUtils.close(rs);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Statement stmt) {
        try {
            DbUtils.close(stmt);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void commitAndClose(Connection conn) throws SQLException {
        if (conn != null) {
            try {
                conn.commit();
            }
            finally {
                conn.close();
            }
        }
    }

    public static void commitAndCloseQuietly(Connection conn) {
        try {
            DbUtils.commitAndClose(conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static boolean loadDriver(String driverClassName) {
        return DbUtils.loadDriver(DbUtils.class.getClassLoader(), driverClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadDriver(ClassLoader classLoader, String driverClassName) {
        try {
            Class<?> loadedClass = classLoader.loadClass(driverClassName);
            if (!Driver.class.isAssignableFrom(loadedClass)) {
                return false;
            }
            Class<?> driverClass = loadedClass;
            Constructor<?> driverConstructor = driverClass.getConstructor(new Class[0]);
            boolean isConstructorAccessible = driverConstructor.isAccessible();
            if (!isConstructorAccessible) {
                driverConstructor.setAccessible(true);
            }
            try {
                Driver driver = (Driver)driverConstructor.newInstance(new Object[0]);
                DriverManager.registerDriver(new DriverProxy(driver));
            }
            finally {
                driverConstructor.setAccessible(isConstructorAccessible);
            }
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void printStackTrace(SQLException e) {
        DbUtils.printStackTrace(e, new PrintWriter(System.err));
    }

    public static void printStackTrace(SQLException e, PrintWriter pw) {
        SQLException next = e;
        while (next != null) {
            next.printStackTrace(pw);
            if ((next = next.getNextException()) == null) continue;
            pw.println("Next SQLException:");
        }
    }

    public static void printWarnings(Connection conn) {
        DbUtils.printWarnings(conn, new PrintWriter(System.err));
    }

    public static void printWarnings(Connection conn, PrintWriter pw) {
        if (conn != null) {
            try {
                DbUtils.printStackTrace(conn.getWarnings(), pw);
            }
            catch (SQLException e) {
                DbUtils.printStackTrace(e, pw);
            }
        }
    }

    public static void rollback(Connection conn) throws SQLException {
        if (conn != null) {
            conn.rollback();
        }
    }

    public static void rollbackAndClose(Connection conn) throws SQLException {
        if (conn != null) {
            try {
                conn.rollback();
            }
            finally {
                conn.close();
            }
        }
    }

    public static void rollbackAndCloseQuietly(Connection conn) {
        try {
            DbUtils.rollbackAndClose(conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static final class DriverProxy
    implements Driver {
        private boolean parentLoggerSupported = true;
        private final Driver adapted;

        public DriverProxy(Driver adapted) {
            this.adapted = adapted;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return this.adapted.acceptsURL(url);
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return this.adapted.connect(url, info);
        }

        @Override
        public int getMajorVersion() {
            return this.adapted.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.adapted.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return this.adapted.getPropertyInfo(url, info);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.adapted.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            if (this.parentLoggerSupported) {
                try {
                    Method method = this.adapted.getClass().getMethod("getParentLogger", new Class[0]);
                    return (Logger)method.invoke((Object)this.adapted, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    this.parentLoggerSupported = false;
                    throw new SQLFeatureNotSupportedException(e);
                }
                catch (IllegalAccessException e) {
                    this.parentLoggerSupported = false;
                    throw new SQLFeatureNotSupportedException(e);
                }
                catch (InvocationTargetException e) {
                    this.parentLoggerSupported = false;
                    throw new SQLFeatureNotSupportedException(e);
                }
            }
            throw new SQLFeatureNotSupportedException();
        }
    }
}

