/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.jdbc.handlers;

import com.github.braisdom.objsql.jdbc.RowProcessor;
import com.github.braisdom.objsql.jdbc.handlers.AbstractKeyedHandler;
import com.github.braisdom.objsql.jdbc.handlers.ArrayHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class KeyedHandler<K>
extends AbstractKeyedHandler<K, Map<String, Object>> {
    protected final RowProcessor convert;
    protected final int columnIndex;
    protected final String columnName;

    public KeyedHandler() {
        this(ArrayHandler.ROW_PROCESSOR, 1, null);
    }

    public KeyedHandler(RowProcessor convert) {
        this(convert, 1, null);
    }

    public KeyedHandler(int columnIndex) {
        this(ArrayHandler.ROW_PROCESSOR, columnIndex, null);
    }

    public KeyedHandler(String columnName) {
        this(ArrayHandler.ROW_PROCESSOR, 1, columnName);
    }

    private KeyedHandler(RowProcessor convert, int columnIndex, String columnName) {
        this.convert = convert;
        this.columnIndex = columnIndex;
        this.columnName = columnName;
    }

    @Override
    protected K createKey(ResultSet rs) throws SQLException {
        return (K)(this.columnName == null ? rs.getObject(this.columnIndex) : rs.getObject(this.columnName));
    }

    @Override
    protected Map<String, Object> createRow(ResultSet rs) throws SQLException {
        return this.convert.toMap(rs);
    }
}

