/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.reflection;

import com.github.braisdom.objsql.reflection.ClassUtils;
import com.github.braisdom.objsql.reflection.PropertyUtils;
import com.github.braisdom.objsql.reflection.ReflectionException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

class PropertyDescriptorCache<T> {
    private final Class<T> originalClass;
    private final Map<String, PropertyDescriptor> propertyDescriptorsByName = new LinkedHashMap<String, PropertyDescriptor>();
    private final Map<Field, PropertyDescriptor> propertyDescriptorsByField = new LinkedHashMap<Field, PropertyDescriptor>();
    private final Map<Method, PropertyDescriptor> propertyDescriptorsByMethod = new LinkedHashMap<Method, PropertyDescriptor>();
    private final Map<Class<? extends Annotation>, Map<PropertyDescriptor, Annotation>> propertyDescriptorsByAnnotation = new LinkedHashMap<Class<? extends Annotation>, Map<PropertyDescriptor, Annotation>>();
    private final Map<PropertyDescriptor, Object> defaultValues = new ConcurrentHashMap<PropertyDescriptor, Object>();

    private PropertyDescriptorCache(Class<T> originalClass) {
        this.originalClass = originalClass;
        for (PropertyDescriptor propertyDescriptor : this.getAllPropertyDescriptors()) {
            Method writeMethod;
            PropertyDescriptor existing = this.propertyDescriptorsByName.putIfAbsent(propertyDescriptor.getName(), propertyDescriptor);
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod != null) {
                this.propertyDescriptorsByMethod.put(readMethod, propertyDescriptor);
                this.putAnnotations(propertyDescriptor, readMethod.getAnnotations());
            }
            if ((writeMethod = propertyDescriptor.getWriteMethod()) == null) continue;
            this.propertyDescriptorsByMethod.put(writeMethod, propertyDescriptor);
            this.putAnnotations(propertyDescriptor, writeMethod.getAnnotations());
        }
        for (Field field : this.getFields()) {
            PropertyDescriptor propertyDescriptor = this.propertyDescriptorsByName.get(field.getName());
            if (propertyDescriptor == null) continue;
            PropertyDescriptor existing = this.propertyDescriptorsByField.putIfAbsent(field, propertyDescriptor);
            this.putAnnotations(propertyDescriptor, field.getAnnotations());
        }
    }

    private Set<Field> getFields() {
        ArrayList<Field> allFields = new ArrayList<Field>();
        PropertyDescriptorCache.collectFields(this.originalClass, allFields);
        allFields.sort(Comparator.comparing(Field::getName));
        return new LinkedHashSet<Field>(allFields);
    }

    private static void collectFields(Class<?> type, Collection<Field> collectedFields) {
        Class<?> superclass;
        collectedFields.addAll(Arrays.asList(type.getFields()));
        collectedFields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (!type.equals(Object.class) && (superclass = type.getSuperclass()) != null) {
            PropertyDescriptorCache.collectFields(superclass, collectedFields);
        }
    }

    private void putAnnotations(PropertyDescriptor propertyDescriptor, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            this.propertyDescriptorsByAnnotation.computeIfAbsent(annotation.annotationType(), k -> new LinkedHashMap()).put(propertyDescriptor, annotation);
        }
    }

    private static Collection<PropertyDescriptor> collectAllPropertyDescriptors(Class<?> type) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            TreeMap<String, PropertyDescriptor> propertyDescriptors = new TreeMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                propertyDescriptors.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            PropertyDescriptorCache.collectPropertyDescriptorsOfInterfaces(type, propertyDescriptors);
            return propertyDescriptors.values();
        }
        catch (IntrospectionException e) {
            throw new ReflectionException(e);
        }
    }

    private static void collectPropertyDescriptorsOfInterfaces(Class<?> type, Map<String, PropertyDescriptor> propertyDescriptors) throws IntrospectionException {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        for (Class<?> typeInterface : type.getInterfaces()) {
            BeanInfo beanInfo = Introspector.getBeanInfo(typeInterface);
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                propertyDescriptors.putIfAbsent(propertyDescriptor.getName(), propertyDescriptor);
            }
            PropertyDescriptorCache.collectPropertyDescriptorsOfInterfaces(typeInterface, propertyDescriptors);
        }
        PropertyDescriptorCache.collectPropertyDescriptorsOfInterfaces(type.getSuperclass(), propertyDescriptors);
    }

    private Collection<PropertyDescriptor> getAllPropertyDescriptors() {
        return PropertyDescriptorCache.collectAllPropertyDescriptors(this.originalClass);
    }

    Collection<PropertyDescriptor> getDescriptors() {
        return Collections.unmodifiableCollection(this.propertyDescriptorsByName.values());
    }

    PropertyDescriptor getDescriptorByMethod(Method method) {
        return this.propertyDescriptorsByMethod.get(method);
    }

    PropertyDescriptor getDescriptorByField(Field field) {
        return this.propertyDescriptorsByField.get(field);
    }

    <A extends Annotation> Map<PropertyDescriptor, A> getDescriptorsForAnnotation(Class<A> annotationClass) {
        Map descriptors = this.propertyDescriptorsByAnnotation.getOrDefault(annotationClass, Collections.emptyMap());
        return Collections.unmodifiableMap(descriptors);
    }

    static <T> PropertyDescriptorCache<T> compute(Class<T> originalClass) {
        return new PropertyDescriptorCache<T>(originalClass);
    }

    PropertyDescriptor getDescriptorByName(String propertyName) {
        return this.propertyDescriptorsByName.get(propertyName);
    }

    Object getDefaultValue(PropertyDescriptor propertyDescriptor) {
        return this.defaultValues.computeIfAbsent(propertyDescriptor, this::determineDefaultValue);
    }

    private Object determineDefaultValue(PropertyDescriptor propertyDescriptor) {
        try {
            T defaultObject = ClassUtils.createNewInstance(this.originalClass);
            return PropertyUtils.read(defaultObject, propertyDescriptor);
        }
        catch (RuntimeException e) {
            throw new ReflectionException("Failed to determine default name for " + PropertyUtils.getQualifiedPropertyName(this.originalClass, propertyDescriptor), e);
        }
    }

    private static void assertHasNoDeclaredFields(Object lambda) {
        if (PropertyDescriptorCache.hasDeclaredFields(lambda)) {
            throw new IllegalArgumentException(lambda + " is call site specific");
        }
    }

    private static boolean hasDeclaredFields(Object lambda) {
        return lambda.getClass().getDeclaredFields().length > 0;
    }
}

