/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.relation;

import com.github.braisdom.objsql.Databases;
import com.github.braisdom.objsql.DomainModelDescriptor;
import com.github.braisdom.objsql.Quoter;
import com.github.braisdom.objsql.SQLExecutor;
import com.github.braisdom.objsql.Tables;
import com.github.braisdom.objsql.relation.RelationProcessor;
import com.github.braisdom.objsql.relation.Relationship;
import com.github.braisdom.objsql.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RelationshipNetwork
implements RelationProcessor.Context {
    private static final String SELECT_RELATION_STATEMENT = "SELECT * FROM %s WHERE %s";
    private final Connection connection;
    private final DomainModelDescriptor domainModelDescriptor;
    private final Map<Class, List> relationObjectsMap;

    public RelationshipNetwork(Connection connection, DomainModelDescriptor domainModelDescriptor) {
        this.connection = connection;
        this.domainModelDescriptor = domainModelDescriptor;
        this.relationObjectsMap = new HashMap<Class, List>();
    }

    @Override
    public List queryRelatedObjects(Class clazz, String associationColumn, Object[] associatedValues, String condition) throws SQLException {
        List cachedObjects = this.relationObjectsMap.get(clazz);
        if (cachedObjects == null) {
            cachedObjects = this.queryObjects(clazz, associationColumn, associatedValues, condition);
            this.relationObjectsMap.put(clazz, cachedObjects);
        }
        return cachedObjects;
    }

    @Override
    public List getObjects(Class clazz) {
        return this.relationObjectsMap.get(clazz);
    }

    public void process(List rows, Relationship[] relationships) throws SQLException {
        this.catchObjects(this.domainModelDescriptor.getDomainModelClass(), rows);
        List baseRelationships = Arrays.stream(relationships).filter(r -> r.getBaseClass().equals(this.domainModelDescriptor.getDomainModelClass())).collect(Collectors.toList());
        for (Relationship relationship : baseRelationships) {
            this.setupAssociatedObjects(relationship, new ArrayList<Relationship>(Arrays.asList(relationships)));
        }
    }

    private void setupAssociatedObjects(Relationship relationship, List<Relationship> relationships) throws SQLException {
        RelationProcessor relationProcessor = relationship.createProcessor();
        relationProcessor.process(this, relationship);
        relationships.remove(relationship);
        Class childClass = relationship.getRelatedClass();
        Relationship[] childRelationships = (Relationship[])relationships.stream().filter(r -> r.getBaseClass().equals(childClass)).toArray(Relationship[]::new);
        if (childRelationships.length > 0) {
            this.setupAssociatedObjects(childRelationships[0], relationships);
        }
    }

    protected List queryObjects(Class clazz, String associatedColumnName, Object[] associatedValues, String condition) throws SQLException {
        String relationTableName = Tables.getTableName(clazz);
        SQLExecutor sqlExecutor = Databases.getSqlExecutor();
        Quoter quoter = Databases.getQuoter();
        String relationConditions = StringUtil.isBlank(condition) ? String.format(" %s IN (%s) ", associatedColumnName, quoter.quoteValue(associatedValues)) : String.format(" %s IN (%s) AND (%s)", associatedColumnName, quoter.quoteValue(associatedValues), condition);
        String relationTableQuerySql = String.format(SELECT_RELATION_STATEMENT, relationTableName, relationConditions);
        return sqlExecutor.query(this.connection, relationTableQuerySql, this.domainModelDescriptor.getRelatedModeDescriptor(clazz), new Object[0]);
    }

    protected void catchObjects(Class clazz, List objects) {
        this.relationObjectsMap.put(clazz, objects);
    }
}

