/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.sql;

import com.github.braisdom.objsql.Tables;
import com.github.braisdom.objsql.sql.AbstractExpression;
import com.github.braisdom.objsql.sql.Dataset;
import com.github.braisdom.objsql.sql.ExpressionContext;
import java.util.Arrays;
import java.util.Objects;

public abstract class AbstractTable
extends AbstractExpression
implements Dataset {
    protected final Class modelClass;

    public AbstractTable(Class modelClass) {
        Objects.requireNonNull(modelClass, "The modelClass cannot be null");
        this.modelClass = modelClass;
    }

    @Override
    public String toSql(ExpressionContext expressionContext) {
        String[] nameParts = Tables.getTableName(this.modelClass).split("\\.");
        CharSequence[] quotedNameParts = (String[])Arrays.stream(nameParts).map(namePart -> expressionContext.quoteTable((String)namePart)).toArray(String[]::new);
        String tableAlias = expressionContext.getAlias(this, true);
        return String.format("%s AS %s", String.join((CharSequence)"\\.", quotedNameParts), tableAlias);
    }
}

