/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.sql;

import com.github.braisdom.objsql.DatabaseType;
import com.github.braisdom.objsql.sql.Dataset;
import com.github.braisdom.objsql.sql.ExpressionContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class DefaultExpressionContext
implements ExpressionContext {
    private final DatabaseType databaseType;
    private final List<Dataset> datasets;

    public DefaultExpressionContext(DatabaseType databaseType) {
        this.databaseType = databaseType;
        this.datasets = new ArrayList<Dataset>();
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public String getAlias(Dataset dataset, boolean forceCreate) {
        if (dataset.getAlias() != null) {
            return dataset.getAlias();
        }
        if (!this.datasets.contains(dataset)) {
            this.datasets.add(dataset);
        }
        return String.format("T%d", this.datasets.indexOf(dataset));
    }

    @Override
    public String quoteTable(String tableName) {
        switch (this.databaseType) {
            case MariaDB: 
            case MySQL5: {
                return String.format("`%s`", tableName);
            }
            case PostgreSQL: 
            case Oracle: 
            case SQLite: 
            case MsSqlServer: {
                return String.format("\"%s\"", tableName);
            }
            case All: {
                return String.format("\"%s\"", tableName);
            }
        }
        return null;
    }

    @Override
    public String quoteColumn(String columnName) {
        switch (this.databaseType) {
            case MariaDB: 
            case MySQL5: {
                return String.format("`%s`", columnName);
            }
            case PostgreSQL: 
            case Oracle: 
            case SQLite: 
            case MsSqlServer: {
                return String.format("\"%s\"", columnName);
            }
            case All: {
                return String.format("\"%s\"", columnName);
            }
        }
        return null;
    }

    @Override
    public String quoteString(String stringValue) {
        return String.format("'%s'", stringValue);
    }

    @Override
    public String toTimestamp(Timestamp timestamp) {
        return null;
    }
}

