/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.sql.expression;

import com.github.braisdom.objsql.sql.Expression;
import com.github.braisdom.objsql.sql.expression.LiteralExpression;
import com.github.braisdom.objsql.sql.expression.ParenExpression;
import com.github.braisdom.objsql.sql.expression.PolynaryExpression;
import java.sql.Timestamp;

public class Expressions {
    public static Expression paren(Expression expression) {
        return new ParenExpression(expression);
    }

    public static Expression plus(Expression left, Expression right, Expression ... others) {
        return new PolynaryExpression(" + ", left, right, others);
    }

    public static Expression minus(Expression left, Expression right, Expression ... others) {
        return new PolynaryExpression(" - ", left, right, others);
    }

    public static Expression multiply(Expression left, Expression right, Expression ... others) {
        return new PolynaryExpression(" * ", left, right, others);
    }

    public static Expression divide(Expression left, Expression right, Expression ... others) {
        return new PolynaryExpression(" / ", left, right, others);
    }

    public static Expression and(Expression left, Expression right, Expression ... others) {
        return new PolynaryExpression(" and ", left, right, others);
    }

    public static Expression or(Expression left, Expression right, Expression ... others) {
        return new PolynaryExpression(" or ", left, right, others);
    }

    public static Expression literal(String string) {
        return new LiteralExpression(string);
    }

    public static Expression literal(Integer integer) {
        return new LiteralExpression(integer);
    }

    public static Expression literal(Float floatLiteral) {
        return new LiteralExpression(floatLiteral);
    }

    public static Expression literal(Double doubleLiteral) {
        return new LiteralExpression(doubleLiteral);
    }

    public static Expression $(String string) {
        return new LiteralExpression(string);
    }

    public static Expression $(Integer integer) {
        return new LiteralExpression(integer);
    }

    public static Expression $(Float floatLiteral) {
        return new LiteralExpression(floatLiteral);
    }

    public static Expression $(Double doubleLiteral) {
        return new LiteralExpression(doubleLiteral);
    }

    public static Expression literal(Timestamp timestamp) {
        return null;
    }
}

