/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.util;

import com.github.braisdom.objsql.util.SuppressedException;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

@FunctionalInterface
public interface FunctionWithThrowable<T, R, E extends Throwable>
extends Function<T, R> {
    public static <T, R, E extends Throwable> FunctionWithThrowable<T, R, E> castFunctionWithThrowable(FunctionWithThrowable<T, R, E> functionwiththrowable) {
        return functionwiththrowable;
    }

    public static <T, R, E extends Throwable> Function<T, R> aFunctionThatUnsafelyThrowsUnchecked(FunctionWithThrowable<T, R, E> functionwiththrowable) throws E {
        return functionwiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <T, R, E extends Throwable> FunctionWithThrowable<T, R, E> asFunctionWithThrowable(Function<T, R> function) {
        return function::apply;
    }

    @Override
    default public R apply(T v1) {
        try {
            return this.applyWithThrowable(v1);
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public R applyWithThrowable(T var1) throws E;

    default public Function<T, Optional<R>> thatReturnsOptional() {
        return v1 -> {
            try {
                return Optional.ofNullable(this.applyWithThrowable(v1));
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
        };
    }

    default public Function<T, R> thatReturnsOnCatch(R defaultReturnValue) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                return defaultReturnValue;
            }
        };
    }

    default public Function<T, R> thatUnsafelyThrowsUnchecked() throws E {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
                return null;
            }
        };
    }

    default public FunctionWithThrowable<T, R, E> onException(Consumer<Throwable> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }

    default public FunctionWithThrowable<T, R, E> onException(BiConsumer<Throwable, Object[]> consumer) {
        return v1 -> {
            try {
                return this.applyWithThrowable(v1);
            }
            catch (Throwable throwable) {
                consumer.accept(throwable, new Object[]{v1});
                throw throwable;
            }
        };
    }
}

