/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql;

import com.github.braisdom.objsql.BeanModelDescriptor;
import com.github.braisdom.objsql.Databases;
import com.github.braisdom.objsql.DomainModelDescriptor;
import com.github.braisdom.objsql.DomainModelException;
import com.github.braisdom.objsql.Query;
import com.github.braisdom.objsql.ValidationException;
import com.github.braisdom.objsql.Validator;
import com.github.braisdom.objsql.annotations.Column;
import com.github.braisdom.objsql.annotations.DomainModel;
import com.github.braisdom.objsql.annotations.PrimaryKey;
import com.github.braisdom.objsql.reflection.PropertyUtils;
import com.github.braisdom.objsql.relation.Relationship;
import com.github.braisdom.objsql.util.StringUtil;
import com.github.braisdom.objsql.util.WordUtil;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.validation.Validation;

public final class Tables {
    public static final String DEFAULT_PRIMARY_KEY = "id";
    public static final String DEFAULT_KEY_SUFFIX = "id";
    private static Validator validator = bean -> {
        javax.validation.Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        Set rawViolations = validator.validate(bean, new Class[0]);
        return (Validator.Violation[])rawViolations.stream().map(violation -> new Validator.Violation(violation.getRootBeanClass(), violation.getMessage(), violation.getInvalidValue(), violation.getPropertyPath().toString())).toArray(Validator.Violation[]::new);
    };

    public static final String getTableName(Class baseClass) {
        Objects.requireNonNull(baseClass, "The baseClass cannot be null");
        DomainModel domainModel = baseClass.getAnnotation(DomainModel.class);
        Objects.requireNonNull(domainModel, "The baseClass must have the DomainModel annotation");
        String tableName = !StringUtil.isBlank(domainModel.tableName()) ? domainModel.tableName() : WordUtil.tableize(baseClass.getSimpleName());
        return tableName;
    }

    public static final PrimaryKey getPrimaryKey(Class tableClass) {
        Field[] fields;
        for (Field field : fields = tableClass.getDeclaredFields()) {
            PrimaryKey primaryKey = field.getDeclaredAnnotation(PrimaryKey.class);
            if (primaryKey == null) continue;
            return primaryKey;
        }
        return null;
    }

    public static final boolean isPrimaryField(Field field) {
        PrimaryKey primaryKey = field.getDeclaredAnnotation(PrimaryKey.class);
        if (primaryKey != null) {
            return true;
        }
        return "id".equals(field.getName());
    }

    public static final Field getPrimaryField(Class tableClass) {
        Field[] fields = tableClass.getDeclaredFields();
        Field defaultField = null;
        Field primaryField = null;
        for (Field field : fields) {
            PrimaryKey primaryKey = field.getDeclaredAnnotation(PrimaryKey.class);
            if (primaryKey != null) {
                primaryField = field;
            }
            if (!"id".equals(field.getName())) continue;
            defaultField = field;
        }
        return primaryField == null ? defaultField : primaryField;
    }

    public static final String getColumnName(Class tableClass, String fieldName) {
        try {
            Field field = tableClass.getDeclaredField(fieldName);
            Column column = field.getDeclaredAnnotation(Column.class);
            if (column != null) {
                return column.name();
            }
            return WordUtil.underscore(field.getName());
        }
        catch (NoSuchFieldException ex) {
            throw new DomainModelException(ex.getMessage(), ex);
        }
    }

    public static Validator getValidator() {
        return validator;
    }

    public static final void installValidator(Validator validator) {
        Tables.validator = validator;
    }

    public static final void validate(Object bean) throws ValidationException {
        Tables.validate(bean, true);
    }

    public static final Validator.Violation[] validate(Object bean, boolean suppressException) throws ValidationException {
        Validator validator = Tables.getValidator();
        Validator.Violation[] violations = validator.validate(bean);
        if (violations.length > 0 && !suppressException) {
            throw new ValidationException(violations);
        }
        return violations;
    }

    public static final void validate(Object[] beans) throws ValidationException {
        Tables.validate(beans, false);
    }

    public static final Validator.Violation[] validate(Object[] beans, boolean suppressException) throws ValidationException {
        Validator validator = Tables.getValidator();
        ArrayList<Validator.Violation> violationList = new ArrayList<Validator.Violation>();
        for (Object bean : beans) {
            Validator.Violation[] violations = validator.validate(bean);
            if (violations.length <= 0) continue;
            violationList.addAll(Arrays.asList(violations));
        }
        if (violationList.size() > 0 && !suppressException) {
            throw new ValidationException(violationList.toArray(new Validator.Violation[0]));
        }
        return violationList.toArray(new Validator.Violation[0]);
    }

    public static final <T> List<T> query(Class<T> domainModelClass, String sql, Object ... params) throws SQLException {
        return Tables.query(new BeanModelDescriptor<T>(domainModelClass), sql, params);
    }

    public static final <T> List<T> query(DomainModelDescriptor<T> domainModelDescriptor, String sql, Object ... params) throws SQLException {
        return Databases.execute((connection, sqlExecutor) -> sqlExecutor.query(connection, sql, domainModelDescriptor, params));
    }

    public static final int execute(String sql, Object ... params) throws SQLException {
        return Databases.execute((connection, sqlExecutor) -> sqlExecutor.execute(connection, sql, params));
    }

    public static final int count(Class<?> domainModelClass, String predicate, Object ... params) throws SQLException {
        Query<?> query = Databases.getQueryFactory().createQuery(domainModelClass);
        String countAlias = "_count";
        List rows = query.select("COUNT(*) AS " + countAlias).where(predicate, params).execute(new Relationship[0]);
        if (rows.size() > 0) {
            Object count = PropertyUtils.getRawAttribute(rows.get(0), countAlias);
            return count == null ? 0 : (Integer)count;
        }
        return 0;
    }

    public static final String encodeDefaultKey(String name) {
        return String.format("%s_%s", name, "id");
    }
}

