/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.jdbc;

import com.github.braisdom.objsql.jdbc.BasicRowProcessor;
import com.github.braisdom.objsql.jdbc.RowProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class ResultSetIterator
implements Iterator<Object[]> {
    private final ResultSet rs;
    private final RowProcessor convert;

    public ResultSetIterator(ResultSet rs) {
        this(rs, new BasicRowProcessor());
    }

    public ResultSetIterator(ResultSet rs, RowProcessor convert) {
        this.rs = rs;
        this.convert = convert;
    }

    @Override
    public boolean hasNext() {
        try {
            return !this.rs.isLast();
        }
        catch (SQLException e) {
            this.rethrow(e);
            return false;
        }
    }

    @Override
    public Object[] next() {
        try {
            this.rs.next();
            return this.convert.toArray(this.rs);
        }
        catch (SQLException e) {
            this.rethrow(e);
            return null;
        }
    }

    @Override
    public void remove() {
        try {
            this.rs.deleteRow();
        }
        catch (SQLException e) {
            this.rethrow(e);
        }
    }

    protected void rethrow(SQLException e) {
        throw new RuntimeException(e.getMessage());
    }

    public static Iterable<Object[]> iterable(final ResultSet rs) {
        return new Iterable<Object[]>(){

            @Override
            public Iterator<Object[]> iterator() {
                return new ResultSetIterator(rs);
            }
        };
    }
}

