/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.frame;

import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BasicDataRow
implements DataRow {
    private final Map<String, Double> targets = new HashMap<String, Double>();
    private final Map<String, String> categoricalTargets = new HashMap<String, String>();
    private final Map<String, Double> values = new HashMap<String, Double>();
    private final List<String> columns = new ArrayList<String>();
    private final List<String> targetColumns = new ArrayList<String>();
    private final List<String> categoricalTargetColumns = new ArrayList<String>();

    @Override
    public double target() {
        return this.getTargetCell(this.targetColumnName());
    }

    @Override
    public String categoricalTarget() {
        return this.getCategoricalTargetCell(this.categoricalTargetColumnName());
    }

    @Override
    public double getTargetCell(String columnName) {
        return this.targets.getOrDefault(columnName, 0.0);
    }

    @Override
    public String getCategoricalTargetCell(String columnName) {
        return this.categoricalTargets.getOrDefault(columnName, "");
    }

    @Override
    public void setTargetCell(String columnName, double value) {
        if (value == 0.0) {
            this.targets.remove(columnName);
        }
        this.targets.put(columnName, value);
    }

    @Override
    public void setCategoricalTargetCell(String columnName, String value) {
        if (StringUtils.isEmpty(value)) {
            this.categoricalTargets.remove(columnName);
        }
        this.categoricalTargets.put(columnName, value);
    }

    @Override
    public void setColumnNames(List<String> inputColumns) {
        this.columns.clear();
        this.columns.addAll(inputColumns);
    }

    @Override
    public void setTargetColumnNames(List<String> outputColumns) {
        this.targetColumns.clear();
        this.targetColumns.addAll(outputColumns);
    }

    @Override
    public void setCategoricalTargetColumnNames(List<String> outputColumns) {
        this.categoricalTargetColumns.clear();
        this.categoricalTargetColumns.addAll(outputColumns);
    }

    @Override
    public DataRow makeCopy() {
        BasicDataRow clone = new BasicDataRow();
        clone.copy(this);
        return clone;
    }

    @Override
    public void copy(DataRow that) {
        this.targets.clear();
        this.categoricalTargets.clear();
        this.values.clear();
        this.columns.clear();
        this.targetColumns.clear();
        this.categoricalTargetColumns.clear();
        for (String c : that.getTargetColumnNames()) {
            this.targets.put(c, that.getTargetCell(c));
        }
        for (String c : that.getColumnNames()) {
            this.values.put(c, that.getCell(c));
        }
        for (String c : that.getCategoricalTargetColumnNames()) {
            this.categoricalTargets.put(c, that.getCategoricalTargetCell(c));
        }
        this.setColumnNames(that.getColumnNames());
        this.setTargetColumnNames(that.getTargetColumnNames());
        this.setCategoricalTargetColumnNames(that.getCategoricalTargetColumnNames());
    }

    @Override
    public String targetColumnName() {
        return this.getTargetColumnNames().get(0);
    }

    @Override
    public String categoricalTargetColumnName() {
        return this.getCategoricalTargetColumnNames().get(0);
    }

    @Override
    public double[] toArray() {
        List<String> cols = this.getColumnNames();
        double[] result = new double[cols.size()];
        for (int i = 0; i < cols.size(); ++i) {
            result[i] = this.getCell(cols.get(i));
        }
        return result;
    }

    private void buildColumns() {
        List cols = this.values.keySet().stream().collect(Collectors.toList());
        cols.sort(String::compareTo);
        this.columns.addAll(cols);
    }

    private void buildTargetColumns() {
        List cols = this.targets.keySet().stream().collect(Collectors.toList());
        cols.sort(String::compareTo);
        this.targetColumns.addAll(cols);
    }

    private void buildCategoricalTargetColumns() {
        List cols = this.categoricalTargets.keySet().stream().collect(Collectors.toList());
        cols.sort(String::compareTo);
        this.categoricalTargetColumns.addAll(cols);
    }

    @Override
    public void setCell(String columnName, double value) {
        if (value == 0.0) {
            this.values.remove(columnName);
        }
        this.values.put(columnName, value);
    }

    @Override
    public List<String> getColumnNames() {
        if (this.columns.size() < this.values.size()) {
            this.buildColumns();
        }
        return this.columns;
    }

    @Override
    public List<String> getTargetColumnNames() {
        if (this.targetColumns.size() < this.targets.size()) {
            this.buildTargetColumns();
        }
        return this.targetColumns;
    }

    @Override
    public List<String> getCategoricalTargetColumnNames() {
        if (this.categoricalTargetColumns.size() < this.categoricalTargets.size()) {
            this.buildCategoricalTargetColumns();
        }
        return this.categoricalTargetColumns;
    }

    @Override
    public double getCell(String key) {
        return this.values.getOrDefault(key, 0.0);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        List<String> keys = this.getColumnNames();
        for (i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(keys.get(i)).append(":").append(this.getCell(keys.get(i)));
        }
        sb.append(" =>");
        keys = this.getTargetColumnNames();
        if (!keys.isEmpty()) {
            sb.append(" (");
            for (i = 0; i < keys.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(keys.get(i)).append(":").append(this.getTargetCell(keys.get(i)));
            }
            sb.append(")");
        }
        if (!(keys = this.getCategoricalTargetColumnNames()).isEmpty()) {
            sb.append(" (");
            for (i = 0; i < keys.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(keys.get(i)).append(":").append(this.getCategoricalTargetCell(keys.get(i)));
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

