/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.utils;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.frame.InputDataColumn;
import com.github.chen0040.data.frame.OutputDataColumn;
import com.github.chen0040.data.utils.Mean;
import com.github.chen0040.data.utils.StdDev;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Scaler {
    private Map<String, Double> means = new HashMap<String, Double>();
    private Map<String, Double> sds = new HashMap<String, Double>();

    public Scaler makeCopy() {
        Scaler clone = new Scaler();
        clone.copy(this);
        return clone;
    }

    public void copy(Scaler that) {
        this.means.clear();
        this.sds.clear();
        this.means.putAll(that.means);
        this.sds.putAll(that.sds);
    }

    public void fit(DataFrame frame) {
        double sd;
        double mean;
        double value;
        double[] values;
        this.means.clear();
        this.sds.clear();
        List inputColumns = frame.getInputColumns().stream().map(InputDataColumn::getColumnName).collect(Collectors.toList());
        List outputColumns = frame.getOutputColumns().stream().map(OutputDataColumn::getColumnName).collect(Collectors.toList());
        for (String c : inputColumns) {
            values = new double[frame.rowCount()];
            for (int i = 0; i < frame.rowCount(); ++i) {
                values[i] = value = frame.row(i).getCell(c);
            }
            mean = Mean.apply(values);
            this.means.put(c, mean);
            sd = StdDev.apply(values, mean);
            this.sds.put(c, sd);
        }
        for (String c : outputColumns) {
            values = new double[frame.rowCount()];
            for (int i = 0; i < frame.rowCount(); ++i) {
                values[i] = value = frame.row(i).getTargetCell(c);
            }
            mean = Mean.apply(values);
            this.means.put(c, mean);
            sd = StdDev.apply(values, mean);
            this.sds.put(c, sd);
        }
    }

    public double transform(String columnName, double value) {
        double mean = this.means.getOrDefault(columnName, 0.0);
        double sd = this.sds.getOrDefault(columnName, 0.0);
        if (sd != 0.0) {
            return (value - mean) / sd;
        }
        return value;
    }

    public double inverseTransform(String columnName, double value) {
        double mean = this.means.getOrDefault(columnName, 0.0);
        double sd = this.sds.getOrDefault(columnName, 0.0);
        if (sd != 0.0) {
            return value * sd + mean;
        }
        return value;
    }

    public DataRow transform(DataRow row) {
        DataRow scaled = row.makeCopy();
        List<String> inputColumns = scaled.getColumnNames();
        for (String c : inputColumns) {
            scaled.setCell(c, this.transform(c, scaled.getCell(c)));
        }
        List<String> outputColumns = scaled.getTargetColumnNames();
        for (String c : outputColumns) {
            scaled.setTargetCell(c, this.transform(c, scaled.getTargetCell(c)));
        }
        return scaled;
    }

    public DataRow inverseTransform(DataRow row) {
        DataRow scaled = row.makeCopy();
        List<String> inputColumns = scaled.getColumnNames();
        for (String c : inputColumns) {
            scaled.setCell(c, this.inverseTransform(c, scaled.getCell(c)));
        }
        List<String> outputColumns = scaled.getTargetColumnNames();
        for (String c : outputColumns) {
            scaled.setTargetCell(c, this.inverseTransform(c, scaled.getTargetCell(c)));
        }
        return scaled;
    }
}

