/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.utils;

import com.github.chen0040.data.utils.CollectionUtils;
import com.github.chen0040.data.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUtils {
    public static final String quoteSplitPM = "(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final Logger logger = LoggerFactory.getLogger(CsvUtils.class);

    public static double atof(String s) {
        double d = Double.valueOf(s);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            System.err.print("NaN or Infinity in input\n");
            System.exit(1);
        }
        return d;
    }

    public static int atoi(String s) {
        int value = 0;
        try {
            value = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            value = 0;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Map<Integer, String>> readHeartScale(InputStream inputStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            List lines = reader.lines().collect(Collectors.toList());
            List<Map<Integer, String>> list = lines.stream().filter(line -> !StringUtils.isEmpty(line)).map(line -> {
                StringTokenizer st = new StringTokenizer((String)line, " \t\n\r\f:");
                String label = st.nextToken();
                HashMap<Integer, String> row = new HashMap<Integer, String>();
                int m = st.countTokens() / 2;
                for (int j = 0; j < m; ++j) {
                    int index = CsvUtils.atoi(st.nextToken());
                    String value = st.nextToken();
                    row.put(index, value);
                }
                row.put(0, label);
                return row;
            }).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            logger.error("Failed to read the heartScale data", (Throwable)e);
            return new ArrayList<Map<Integer, String>>();
        }
    }

    public static boolean csv(InputStream inputStream, String cvsSplitBy, int skippedLineCount, Function<String[], Boolean> onLineReady, Consumer<Exception> onFailed) {
        if (cvsSplitBy == null) {
            cvsSplitBy = ",";
        }
        boolean success = true;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            int lineCount = 0;
            while ((line = br.readLine()) != null) {
                if (++lineCount <= skippedLineCount || (line = line.trim()).equals("")) continue;
                boolean containsQuote = false;
                if (line.contains("\"")) {
                    containsQuote = true;
                    cvsSplitBy = cvsSplitBy + quoteSplitPM;
                }
                String[] values = CsvUtils.filterEmpty(line.split(cvsSplitBy));
                if (containsQuote) {
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = StringUtils.stripQuote(values[i]);
                    }
                }
                if (onLineReady == null) continue;
                onLineReady.apply(values);
            }
        }
        catch (IOException e) {
            success = false;
            if (onFailed != null) {
                onFailed.accept(e);
            }
            e.printStackTrace();
        }
        return success;
    }

    private static String[] filterEmpty(String[] a) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < a.length; ++i) {
            String v = a[i].trim();
            if (StringUtils.isEmpty(v)) continue;
            result.add(v);
        }
        return CollectionUtils.toArray(result);
    }
}

