/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.utils.discretizers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class KMeansFilter {
    private static Random random = new Random();
    private int clusterCount;
    private double[] clusters;
    private int maxIters = 500;
    private String columnName;

    public KMeansFilter makeCopy() {
        KMeansFilter clone = new KMeansFilter();
        clone.copy(this);
        return clone;
    }

    public void copy(KMeansFilter rhs) {
        this.clusterCount = rhs.clusterCount;
        this.columnName = rhs.columnName;
        this.clusters = rhs.clusters == null ? null : (double[])rhs.clusters.clone();
        this.maxIters = rhs.maxIters;
    }

    public KMeansFilter(String columnName, int k) {
        this.columnName = columnName;
        this.clusterCount = k;
    }

    public KMeansFilter() {
        this.clusterCount = 10;
    }

    public int getClusterCount() {
        return this.clusterCount;
    }

    public void setClusterCount(int clusterCount) {
        this.clusterCount = clusterCount;
    }

    public int getMaxIters() {
        return this.maxIters;
    }

    public void setMaxIters(int maxIters) {
        this.maxIters = maxIters;
    }

    public void build(List<Double> values) {
        int m = values.size();
        HashSet<Integer> initialCenters = new HashSet<Integer>();
        if (this.clusterCount * 3 > m) {
            this.clusterCount = Math.min(this.clusterCount, m);
            for (int i = 0; i < this.clusterCount; ++i) {
                initialCenters.add(i);
            }
        } else {
            while (initialCenters.size() < this.clusterCount) {
                int r = random.nextInt(m);
                if (initialCenters.contains(r)) continue;
                initialCenters.add(r);
            }
        }
        this.clusters = new double[this.clusterCount];
        int centerIndex = 0;
        for (Integer index : initialCenters) {
            this.clusters[centerIndex] = values.get(index);
            ++centerIndex;
        }
        ArrayList cluster_groups = new ArrayList();
        for (int i = 0; i < this.clusterCount; ++i) {
            cluster_groups.add(new ArrayList());
        }
        for (int iter = 0; iter < this.maxIters; ++iter) {
            int i;
            for (i = 0; i < this.clusterCount; ++i) {
                ((List)cluster_groups.get(i)).clear();
            }
            for (i = 0; i < m; ++i) {
                int clusterIndex = this.closestClusterIndex(values.get(i));
                ((List)cluster_groups.get(clusterIndex)).add(i);
            }
            for (i = 0; i < this.clusterCount; ++i) {
                this.clusters[i] = this.calcCenter(values, (List)cluster_groups.get(i), this.clusters[i]);
            }
        }
    }

    private double calcCenter(List<Double> values, List<Integer> cluster, double center) {
        double newCenter = 0.0;
        int m = cluster.size();
        for (int i = 0; i < m; ++i) {
            newCenter += values.get(cluster.get(i)).doubleValue();
        }
        if (m == 0) {
            return center;
        }
        return newCenter /= (double)m;
    }

    public int discretize(double value) {
        return this.closestClusterIndex(value);
    }

    private int closestClusterIndex(double value) {
        double min_distance = Double.MAX_VALUE;
        int closest_cluster_index = -1;
        for (int i = 0; i < this.clusters.length; ++i) {
            double distance = (this.clusters[i] - value) * (this.clusters[i] - value);
            if (!(distance < min_distance)) continue;
            min_distance = distance;
            closest_cluster_index = i;
        }
        return closest_cluster_index;
    }
}

