/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.utils.transforms;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import java.util.List;

public class ComplementaryCoding
implements Cloneable {
    private double[] minValues;
    private double[] maxValues;

    public void copy(ComplementaryCoding rhs) {
        this.minValues = (double[])rhs.minValues.clone();
        this.maxValues = (double[])rhs.maxValues.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        ComplementaryCoding clone = (ComplementaryCoding)super.clone();
        clone.copy(this);
        return clone;
    }

    public ComplementaryCoding() {
    }

    public ComplementaryCoding(DataFrame batch) {
        this.query(batch);
    }

    public ComplementaryCoding(List<double[]> batch) {
        this.query(batch);
    }

    public double[] revert(double[] x) {
        int m = x.length / 2;
        double[] y = new double[m];
        for (int i = 0; i < m; ++i) {
            y[i] = x[i] * (this.maxValues[i] - this.minValues[i]) + this.minValues[i];
        }
        return y;
    }

    public double[] normalize(double[] x) {
        int i;
        double[] y = new double[x.length * 2];
        for (i = 0; i < x.length; ++i) {
            y[i] = (x[i] - this.minValues[i]) / (this.maxValues[i] - this.minValues[i]);
        }
        for (i = x.length; i < x.length * 2; ++i) {
            y[i] = 1.0 - y[i - x.length];
        }
        return y;
    }

    protected void query(List<double[]> batch) {
        int i;
        int dimension = batch.get(0).length;
        int m = batch.size();
        this.minValues = new double[dimension];
        this.maxValues = new double[dimension];
        for (i = 0; i < dimension; ++i) {
            this.minValues[i] = Double.MAX_VALUE;
            this.maxValues[i] = Double.MIN_VALUE;
        }
        for (i = 0; i < m; ++i) {
            double[] x = batch.get(i);
            for (int j = 0; j < dimension; ++j) {
                this.maxValues[j] = Math.max(x[j], this.maxValues[j]);
                this.minValues[j] = Math.min(x[j], this.minValues[j]);
            }
        }
    }

    protected void query(DataFrame batch) {
        int i;
        int dimension = batch.row(0).toArray().length;
        int m = batch.rowCount();
        this.minValues = new double[dimension];
        this.maxValues = new double[dimension];
        for (i = 0; i < dimension; ++i) {
            this.minValues[i] = Double.MAX_VALUE;
            this.maxValues[i] = Double.MIN_VALUE;
        }
        for (i = 0; i < m; ++i) {
            DataRow tuple = batch.row(i);
            double[] x = tuple.toArray();
            for (int j = 0; j < dimension; ++j) {
                this.maxValues[j] = Math.max(x[j], this.maxValues[j]);
                this.minValues[j] = Math.min(x[j], this.minValues[j]);
            }
        }
    }
}

