/*
 * Decompiled with CFR 0.152.
 */
package com.github.jratelimit.filter;

import com.alibaba.fastjson.JSON;
import com.github.jratelimit.annotation.RateLimit;
import com.github.jratelimit.filter.ControllerRateLimitHandler;
import com.github.jratelimit.filter.LocalControllerRateLimitHandler;
import com.github.jratelimit.support.ServiceRateLimitConfig;
import com.github.jratelimit.support.ServiceRateLimitCounter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ControllerRateLimitInterceptor
implements HandlerInterceptor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, Object> defaultValueMaps = new ConcurrentHashMap<String, Object>();
    private ControllerRateLimitHandler rateLimitHandler;

    public ControllerRateLimitInterceptor() throws IOException {
        this(new LocalControllerRateLimitHandler());
    }

    public ControllerRateLimitInterceptor(ControllerRateLimitHandler rateLimitHandler) {
        this.rateLimitHandler = rateLimitHandler;
        Thread daemon = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        this.qps();
                        ServiceRateLimitCounter.clearCounter();
                        TimeUnit.SECONDS.sleep(1L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        daemon.setDaemon(true);
        daemon.setName("ControllerRateLimitInterceptor-daemon-Thread0");
        daemon.start();
    }

    private void qps() {
        Map<String, Integer> limitConfigMaps = this.rateLimitHandler.limitConfig();
        if (MapUtils.isNotEmpty(limitConfigMaps)) {
            for (Map.Entry<String, Integer> entry : limitConfigMaps.entrySet()) {
                Long currentQps;
                String methodName = entry.getKey();
                Integer limit = entry.getValue();
                if (null == limit || limit <= 0 || (currentQps = Long.valueOf(ServiceRateLimitCounter.getRate(methodName))) <= (long)limit.intValue()) continue;
                Object methodDefaultValue = defaultValueMaps.get(methodName);
                Long beLimit = currentQps - (long)limit.intValue();
                if (null != methodDefaultValue) {
                    String methodDefaultValueString = JSON.toJSONString((Object)methodDefaultValue);
                    this.logger.warn("[{}] Method triggers a limit configuration , CurrentQps:{} , Config:{}, be limiting:{} , The default data format:{}", new Object[]{methodName, currentQps, limit, beLimit, methodDefaultValueString});
                    continue;
                }
                this.logger.warn("[{}] Method triggers a limit configuration , CurrentQps:{} , Config:{}, be limiting:{}", new Object[]{methodName, currentQps, limit, beLimit});
            }
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod mHandler = (HandlerMethod)handler;
            if (null == mHandler) {
                return true;
            }
            RateLimit rateLimit = (RateLimit)mHandler.getMethodAnnotation(RateLimit.class);
            if (null == rateLimit) {
                return true;
            }
            String interfaceName = mHandler.getBean().getClass().getName();
            String methodName = mHandler.getMethod().getName();
            String rateLimitName = ServiceRateLimitConfig.getMode() != false ? interfaceName + "." + methodName : methodName;
            long methodQps = ServiceRateLimitCounter.incrementAndGet(rateLimitName);
            Map<String, Integer> limitConfig = this.rateLimitHandler.limitConfig();
            Integer methodLimited = limitConfig.get(rateLimitName);
            if (null == methodLimited || methodLimited == 0) {
                return true;
            }
            if (methodQps > (long)methodLimited.intValue()) {
                String defaultMethodName = rateLimit.defaultMethod();
                Object resultDefaultValue = null;
                if (StringUtils.isEmpty((CharSequence)defaultMethodName)) {
                    resultDefaultValue = this.rateLimitHandler.defaultValue(request, response, handler);
                } else {
                    try {
                        Method[] methods;
                        Object target = mHandler.getBean();
                        Method defaultMethod = null;
                        for (Method targetMethod : methods = target.getClass().getDeclaredMethods()) {
                            if (!targetMethod.getName().equals(defaultMethodName)) continue;
                            defaultMethod = targetMethod;
                            break;
                        }
                        if (null != defaultMethod) {
                            Collection paramsValues = request.getParameterMap().values();
                            Object[] params = new Object[paramsValues.size()];
                            int i = 0;
                            for (String[] value : paramsValues) {
                                params[i] = value[0];
                                ++i;
                            }
                            resultDefaultValue = defaultMethod.invoke(target, params);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                defaultValueMaps.put(rateLimitName, resultDefaultValue);
                try {
                    response.addHeader("Content-Type", "application/json; charset=utf-8");
                    response.getWriter().print(resultDefaultValue);
                    response.getWriter().flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

