/*
 * Decompiled with CFR 0.152.
 */
package com.github.jratelimit.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.fastjson.JSON;
import com.github.jratelimit.annotation.RateLimit;
import com.github.jratelimit.filter.DubboRateLimitHandler;
import com.github.jratelimit.filter.LocalDubboRateLimitHandler;
import com.github.jratelimit.support.ApplicationContextHolder;
import com.github.jratelimit.support.ServiceRateLimitConfig;
import com.github.jratelimit.support.ServiceRateLimitCounter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"})
public class DubboRateLimitFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, Object> defaultValueMaps = new ConcurrentHashMap<String, Object>();
    private DubboRateLimitHandler rateLimitHandler = ApplicationContextHolder.getBean(DubboRateLimitHandler.class);

    public DubboRateLimitFilter() throws IOException {
        if (null == this.rateLimitHandler) {
            this.rateLimitHandler = new LocalDubboRateLimitHandler();
        }
        Thread daemon = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        this.qps();
                        ServiceRateLimitCounter.clearCounter();
                        TimeUnit.SECONDS.sleep(1L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        daemon.setDaemon(true);
        daemon.setName("DubboRateLimitFilter-daemon-Thread0");
        daemon.start();
    }

    private void qps() {
        Map<String, Integer> limitConfigMaps = this.rateLimitHandler.limitConfig();
        if (MapUtils.isNotEmpty(limitConfigMaps)) {
            for (Map.Entry<String, Integer> entry : limitConfigMaps.entrySet()) {
                String methodName = entry.getKey();
                Integer limit = entry.getValue();
                if (null == limit || limit <= 0) continue;
                Long currentQps = ServiceRateLimitCounter.getRate(methodName);
                Long beLimit = currentQps - (long)limit.intValue();
                if (currentQps <= (long)limit.intValue()) continue;
                Object methodDefaultValue = defaultValueMaps.get(methodName);
                if (null != methodDefaultValue) {
                    String methodDefaultValueString = JSON.toJSONString((Object)methodDefaultValue);
                    this.logger.warn("[{}] Method triggers a limit configuration , CurrentQps:{} , Config:{}, be limiting:{} , The default data format:{}", new Object[]{methodName, currentQps, limit, beLimit, methodDefaultValueString});
                    continue;
                }
                this.logger.warn("[{}] Method triggers a limit configuration , CurrentQps:{} , Config:{}, be limiting:{}", new Object[]{methodName, currentQps, limit, beLimit});
            }
        }
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String interfaceName = invoker.getInterface().getName();
        String methodName = invocation.getMethodName();
        Method method = null;
        try {
            method = invoker.getInterface().getDeclaredMethod(methodName, invocation.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (null == method) {
            return invoker.invoke(invocation);
        }
        RateLimit rateLimit = method.getAnnotation(RateLimit.class);
        if (null == rateLimit) {
            return invoker.invoke(invocation);
        }
        String rateLimitName = ServiceRateLimitConfig.getMode() != false ? interfaceName + "." + methodName : methodName;
        long methodQps = ServiceRateLimitCounter.incrementAndGet(rateLimitName);
        Map<String, Integer> limitConfig = this.rateLimitHandler.limitConfig();
        Integer methodLimited = limitConfig.get(rateLimitName);
        if (null == methodLimited || methodLimited == 0) {
            return invoker.invoke(invocation);
        }
        if (methodQps > (long)methodLimited.intValue()) {
            String defaultMethodName = rateLimit.defaultMethod();
            Object resultDefaultValue = null;
            if (StringUtils.isEmpty((CharSequence)defaultMethodName)) {
                resultDefaultValue = this.rateLimitHandler.defaultValue(interfaceName, methodName, invocation.getParameterTypes());
            } else {
                try {
                    Method[] methods;
                    Object target = ApplicationContextHolder.getBean(invoker.getInterface());
                    Method defaultMethod = null;
                    for (Method targetMethod : methods = target.getClass().getDeclaredMethods()) {
                        if (!targetMethod.getName().equals(defaultMethodName)) continue;
                        defaultMethod = targetMethod;
                        break;
                    }
                    if (null != defaultMethod) {
                        resultDefaultValue = defaultMethod.invoke(target, invocation.getArguments());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            defaultValueMaps.put(rateLimitName, resultDefaultValue);
            return new RpcResult(resultDefaultValue);
        }
        return invoker.invoke(invocation);
    }
}

