/*
 * Decompiled with CFR 0.152.
 */
package httpserver.error;

import httpserver.core.ContentType;
import httpserver.core.HttpServerExchange;
import httpserver.util.Encoding;
import java.nio.charset.StandardCharsets;

public interface HttpError {
    public static final String RESPONSE_INTERNAL_ERROR = "{\"success\":false,\"code\":500,\"message\":\"Internal Error\"}";
    public static final String ERROR_MESSAGE = "{\"success\":false,\"code\":%d,\"errorCode\":%d,\"message\":\"%s\"}";

    public void processExchange(HttpServerExchange var1);

    public static void respondInternalError(HttpServerExchange httpServerExchange) {
        if (!httpServerExchange.isResponseSent()) {
            httpServerExchange.setStatusCode(500);
            httpServerExchange.setResponseHeader("Content-Type", ContentType.application_json.toString());
            httpServerExchange.send(RESPONSE_INTERNAL_ERROR, StandardCharsets.UTF_8);
        }
    }

    public static void respondError(HttpServerExchange httpServerExchange, int n, int n2, String string) {
        if (!httpServerExchange.isResponseSent()) {
            httpServerExchange.setStatusCode(n);
            httpServerExchange.setResponseHeader("Content-Type", ContentType.application_json.toString());
            httpServerExchange.send(HttpError.errorMessage(n, n2, string), StandardCharsets.UTF_8);
        }
    }

    private static String errorMessage(int n, int n2, String string) {
        return String.format(ERROR_MESSAGE, n, n2, Encoding.escapeJson(string));
    }
}

