/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.paging;

import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.queries.Query;
import java.util.List;
import java.util.stream.Stream;

public class PaginationResult<T extends BaseEntity> {
    protected final List<Query<T>> queries;

    public PaginationResult(List<Query<T>> queries) {
        this.queries = queries;
    }

    public int getNumberOfPages() {
        return this.queries.size();
    }

    private void pageNumberCheck(int pageNumber) {
        if (pageNumber > this.queries.size()) {
            throw new IllegalArgumentException("The requested page number exceeds the total number of pages.");
        }
        if (pageNumber == 0) {
            throw new IllegalArgumentException("The first page starts at the index 1.");
        }
    }

    public List<T> getPage(int number) {
        this.pageNumberCheck(number);
        return this.queries.get(number - 1).toList();
    }

    public Stream<T> getPageAsStream(int number) {
        this.pageNumberCheck(number);
        return this.queries.get(number - 1).toStream();
    }
}

