/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.BinaryExpression;
import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.DelegateExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.Interpreter;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.InvocationExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.MemberExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.UnaryExpression;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;

public abstract class SimpleExpressionVisitor
implements ExpressionVisitor<Expression> {
    private Deque<List<Expression>> argumentsStack = new ArrayDeque<List<Expression>>();

    protected List<Expression> getContextArguments() {
        return this.argumentsStack.peek();
    }

    protected <T extends Expression> List<T> visitExpressionList(List<T> original) {
        if (original != null) {
            ArrayList<Expression> list = null;
            int n = original.size();
            for (int i = 0; i < n; ++i) {
                Expression p = ((Expression)original.get(i)).accept(this);
                if (list != null) {
                    list.add(p);
                    continue;
                }
                if (p == original.get(i)) continue;
                list = new ArrayList<Expression>(n);
                for (int j = 0; j < i; ++j) {
                    list.add((Expression)original.get(j));
                }
                list.add(p);
            }
            if (list != null) {
                return Collections.unmodifiableList(list);
            }
        }
        return original;
    }

    protected List<Expression> visitArguments(List<Expression> original) {
        return this.visitExpressionList(original);
    }

    protected List<ParameterExpression> visitParameters(List<ParameterExpression> original) {
        return this.visitExpressionList(original);
    }

    @Override
    public Expression visit(BinaryExpression e) {
        Expression visitedOp;
        Expression first = e.getFirst();
        Expression visitedFirst = first.accept(this);
        Expression second = e.getSecond();
        Expression visitedSecond = second.accept(this);
        Expression op = e.getOperator();
        Expression expression = visitedOp = op != null ? op.accept(this) : op;
        if (first != visitedFirst || second != visitedSecond || op != visitedOp) {
            return Expression.binary(e.getExpressionType(), visitedOp, visitedFirst, visitedSecond);
        }
        return e;
    }

    @Override
    public Expression visit(ConstantExpression e) {
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expression visit(InvocationExpression e) {
        List<Expression> arguments = e.getArguments();
        InvocableExpression target = e.getTarget();
        boolean visitTargetWithOldArgs = target.getExpressionType() == 23 || target.getExpressionType() == 18;
        boolean cleanArgsStack = false;
        if (!visitTargetWithOldArgs) {
            this.argumentsStack.push(arguments);
            cleanArgsStack = true;
        }
        try {
            List<Expression> args;
            target.accept(this);
            if (visitTargetWithOldArgs) {
                this.argumentsStack.push(arguments);
                cleanArgsStack = true;
            }
            if ((args = this.visitArguments(arguments)) != e.getArguments() || target != e.getTarget()) {
                InvocationExpression invocationExpression = Expression.invoke(target, args);
                return invocationExpression;
            }
            InvocationExpression invocationExpression = e;
            return invocationExpression;
        }
        finally {
            if (cleanArgsStack) {
                this.argumentsStack.pop();
            }
        }
    }

    @Override
    public Expression visit(LambdaExpression<?> e) {
        Expression body = e.getBody().accept(this);
        List<ParameterExpression> parameters = this.visitParameters(e.getParameters());
        if (body != e.getBody()) {
            return Expression.lambda(e.getResultType(), body, parameters);
        }
        return e;
    }

    @Override
    public Expression visit(DelegateExpression e) {
        Object value;
        Expression delegate = e.getDelegate().accept(this);
        Object result = ((Function)delegate.accept(Interpreter.Instance)).apply(this.argumentsStack.peek().toArray());
        if (result instanceof ConstantExpression && (value = ((ConstantExpression)result).getValue()) instanceof Expression) {
            ((Expression)value).accept(this);
        }
        List<ParameterExpression> parameters = this.visitParameters(e.getParameters());
        if (delegate != e.getDelegate()) {
            return Expression.delegate(e.getResultType(), delegate, parameters);
        }
        return e;
    }

    @Override
    public Expression visit(MemberExpression e) {
        Expression instance = e.getInstance();
        if (instance != null && (instance = instance.accept(this)) != e.getInstance()) {
            return Expression.member(e.getExpressionType(), instance, e.getMember(), e.getResultType(), this.visitParameters(e.getParameters()));
        }
        return e;
    }

    @Override
    public Expression visit(ParameterExpression e) {
        return e;
    }

    @Override
    public Expression visit(UnaryExpression e) {
        Expression visitedOp;
        Expression operand = e.getFirst();
        if (operand != (visitedOp = operand.accept(this))) {
            return Expression.unary(e.getExpressionType(), e.getResultType(), visitedOp);
        }
        return e;
    }
}

