/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.database;

import com.github.collinalpert.java2db.exceptions.ConnectionFailedException;
import com.github.collinalpert.java2db.mappers.FieldMapper;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.java2db.queries.StoredProcedureQuery;
import com.github.collinalpert.java2db.queries.async.AsyncQueryable;
import com.github.collinalpert.java2db.queries.async.AsyncStoredProcedureQuery;
import com.github.collinalpert.java2db.utilities.Utilities;
import com.mysql.cj.exceptions.CJCommunicationsException;
import com.mysql.cj.jdbc.exceptions.CommunicationsException;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class DBConnection
implements Closeable {
    public static String HOST;
    public static String DATABASE;
    public static String USERNAME;
    public static String PASSWORD;
    public static int PORT;
    public static int TIMEOUT;
    public static boolean LOG_QUERIES;
    private Connection connection;
    private boolean isConnectionValid;

    public DBConnection() {
        try {
            String connectionString = String.format("jdbc:mysql://%s:%d/%s?rewriteBatchedStatements=true", HOST, PORT, DATABASE);
            Class.forName("com.mysql.cj.jdbc.Driver");
            System.setProperty("user", USERNAME);
            System.setProperty("password", PASSWORD);
            DriverManager.setLoginTimeout(TIMEOUT);
            this.connection = DriverManager.getConnection(connectionString, System.getProperties());
            this.isConnectionValid = true;
        }
        catch (CJCommunicationsException | CommunicationsException e) {
            this.isConnectionValid = false;
            throw new ConnectionFailedException();
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
            this.isConnectionValid = false;
        }
    }

    public boolean isValid() {
        return this.isConnectionValid;
    }

    public ResultSet execute(String query) throws SQLException {
        Statement statement = this.connection.createStatement();
        this.log(query);
        ResultSet set = statement.executeQuery(query);
        statement.closeOnCompletion();
        return set;
    }

    public ResultSet execute(String query, Object ... params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(query);
        for (int i = 0; i < params.length; ++i) {
            statement.setObject(i + 1, params[i]);
        }
        this.log(query);
        ResultSet set = statement.executeQuery();
        statement.closeOnCompletion();
        return set;
    }

    public long update(String query) throws SQLException {
        Statement statement = this.connection.createStatement();
        this.log(query);
        statement.executeUpdate(query, 1);
        return this.updateInternal(statement);
    }

    public long update(String query, Object ... params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(query, 1);
        for (int i = 0; i < params.length; ++i) {
            statement.setObject(i + 1, params[i]);
        }
        this.log(query);
        statement.executeUpdate();
        return this.updateInternal(statement);
    }

    public boolean isOpen() {
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException e) {
            System.err.println("Could not determine connection status");
            this.isConnectionValid = false;
            return false;
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            System.err.println("Could not close database connection");
            e.printStackTrace();
        }
        finally {
            this.isConnectionValid = false;
        }
    }

    public <T> Optional<T> callFunction(Class<T> returnType, String functionName, Object ... arguments) throws SQLException {
        StringJoiner joiner = new StringJoiner(",");
        for (int i = 0; i < arguments.length; ++i) {
            joiner.add("?");
        }
        try (ResultSet set = this.execute(String.format("select %s(%s);", functionName, joiner.toString()), arguments);){
            Optional<T> optional = new FieldMapper<T>(returnType).map(set);
            return optional;
        }
    }

    public <T> CompletableFuture<Optional<T>> callFunctionAsync(Consumer<SQLException> exceptionHandler, Class<T> returnType, String functionName, Object ... arguments) {
        return CompletableFuture.supplyAsync(Utilities.supplierHandling(() -> this.callFunction(returnType, functionName, arguments), exceptionHandler));
    }

    public <T> Queryable<T> callStoredProcedure(Class<T> returnType, String storedProcedureName, Object ... arguments) {
        return new StoredProcedureQuery<T>(returnType, this, storedProcedureName, arguments);
    }

    public <T> AsyncQueryable<T> callStoredProcedureAsync(Class<T> returnType, String storedProcedureName, Object ... arguments) {
        return new AsyncStoredProcedureQuery<T>(returnType, this, storedProcedureName, arguments);
    }

    private void log(String text) {
        if (LOG_QUERIES) {
            System.out.println(text);
        }
    }

    private long updateInternal(Statement statement) throws SQLException {
        statement.closeOnCompletion();
        ResultSet set = statement.getGeneratedKeys();
        if (set.next()) {
            return set.getLong(1);
        }
        return -1L;
    }

    static {
        PORT = 3306;
        TIMEOUT = 5;
        LOG_QUERIES = true;
    }
}

