/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.mappers.FieldMapper;
import com.github.collinalpert.java2db.mappers.Mappable;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.java2db.utilities.ThrowableSupplier;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class StoredProcedureQuery<T>
implements Queryable<T> {
    private final Class<T> underlyingClass;
    private final Mappable<T> mapper;
    private final DBConnection connection;
    private final String procedureName;
    private final Object[] arguments;

    public StoredProcedureQuery(Class<T> underlyingClass, DBConnection connection, String procedureName, Object[] arguments) {
        this.connection = connection;
        this.procedureName = procedureName;
        this.arguments = arguments;
        this.underlyingClass = underlyingClass;
        this.mapper = new FieldMapper<T>(underlyingClass);
    }

    @Override
    public List<T> toList() {
        return this.materializeInternal(() -> this.mapper.mapToList(this.connection.execute(this.getQuery(), this.arguments)), Collections::emptyList);
    }

    @Override
    public Stream<T> toStream() {
        return this.materializeInternal(() -> this.mapper.mapToStream(this.connection.execute(this.getQuery(), this.arguments)), Stream::empty);
    }

    @Override
    public T[] toArray() {
        return this.materializeInternal(() -> this.mapper.mapToArray(this.connection.execute(this.getQuery(), this.arguments)), () -> (Object[])Array.newInstance(this.underlyingClass, 0));
    }

    @Override
    public <K, V> Map<K, V> toMap(Function<T, K> keyMapping, Function<T, V> valueMapping) {
        return this.materializeInternal(() -> this.mapper.mapToMap(this.connection.execute(this.getQuery(), this.arguments), keyMapping, valueMapping), Collections::emptyMap);
    }

    @Override
    public Optional<T> first() {
        return this.materializeInternal(() -> this.mapper.map(this.connection.execute(this.getQuery(), this.arguments)), Optional::empty);
    }

    @Override
    public String getQuery() {
        StringJoiner joiner = new StringJoiner(",");
        for (int i = 0; i < this.arguments.length; ++i) {
            joiner.add("?");
        }
        return String.format("call %s(%s);", this.procedureName, joiner.toString());
    }

    private <R> R materializeInternal(ThrowableSupplier<R, SQLException> valueFunction, Supplier<R> exceptionFunction) {
        try {
            return valueFunction.fetch();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return exceptionFunction.get();
        }
    }
}

