/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.utilities;

import com.github.collinalpert.java2db.exceptions.AsynchronousOperationException;
import com.github.collinalpert.java2db.utilities.ThrowableRunnable;
import com.github.collinalpert.java2db.utilities.ThrowableSupplier;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Utilities {
    public static <V> Supplier<V> supplierHandling(ThrowableSupplier<V, SQLException> supplier, Consumer<SQLException> exceptionHandling) {
        return () -> {
            try {
                return supplier.fetch();
            }
            catch (SQLException e) {
                if (exceptionHandling != null) {
                    exceptionHandling.accept(e);
                    return null;
                }
                throw new AsynchronousOperationException(e);
            }
        };
    }

    public static Runnable runnableHandling(ThrowableRunnable<SQLException> runnable, Consumer<SQLException> exceptionHandling) {
        return () -> {
            try {
                runnable.doAction();
            }
            catch (SQLException e) {
                if (exceptionHandling != null) {
                    exceptionHandling.accept(e);
                }
                throw new AsynchronousOperationException(e);
            }
        };
    }

    public static <E extends Throwable> void tryAction(ThrowableRunnable<E> runnable) {
        try {
            runnable.doAction();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Underlying method threw an exception.", e);
        }
    }

    public static <T, E extends Throwable> T tryGetValue(ThrowableSupplier<T, E> supplier) {
        try {
            return supplier.fetch();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Underlying method threw an exception.", e);
        }
    }
}

