/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.modules;

import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.annotations.ForeignKeyPath;
import com.github.collinalpert.java2db.annotations.Ignore;
import com.github.collinalpert.java2db.database.ForeignKeyReference;
import com.github.collinalpert.java2db.database.TableColumnReference;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.modules.AnnotationModule;
import com.github.collinalpert.java2db.modules.TableModule;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FieldModule {
    private static final FieldModule instance = new FieldModule();
    private static final TableModule tableModule = TableModule.getInstance();
    private static final AnnotationModule annotationModule = AnnotationModule.getInstance();

    public static FieldModule getInstance() {
        return instance;
    }

    public List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass) {
        return this.getEntityFields(instanceClass, null, false);
    }

    public List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass, boolean includeForeignKeys) {
        return this.getEntityFields(instanceClass, null, includeForeignKeys);
    }

    public List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass, Class<?> delimiter) {
        return this.getEntityFields(instanceClass, delimiter, false);
    }

    private <E extends BaseEntity> List<Field> getEntityFields(Class<? super E> instanceClass, Class<?> delimiter, boolean includeForeignKeys) {
        LinkedList<Field> fields = new LinkedList<Field>();
        do {
            Arrays.stream(instanceClass.getDeclaredFields()).filter(field -> field.getAnnotation(Ignore.class) == null && !Modifier.isTransient(field.getModifiers()) && (includeForeignKeys || field.getAnnotation(ForeignKeyEntity.class) == null)).forEach(fields::add);
        } while ((instanceClass = instanceClass.getSuperclass()) != delimiter);
        return fields;
    }

    public List<TableColumnReference> getColumnReferences(Class<? extends BaseEntity> instanceClass) {
        return this.getColumnReferences(instanceClass, "", 0);
    }

    private List<TableColumnReference> getColumnReferences(Class<? extends BaseEntity> instanceClass, String alias, int aliasCounter) {
        LinkedList<TableColumnReference> fields = new LinkedList<TableColumnReference>();
        for (Field field : this.getEntityFields(instanceClass, true)) {
            if (field.getType().isEnum()) continue;
            if (annotationModule.hasAnnotation(field, ForeignKeyEntity.class)) {
                AnnotationModule.AnnotationInfo<ForeignKeyPath> foreignKeyPathInfo = annotationModule.getAnnotationInfo(field, ForeignKeyPath.class);
                if (foreignKeyPathInfo.hasAnnotation()) {
                    String foreignKeyTableName = tableModule.getTableName(foreignKeyPathInfo.getAnnotation().foreignKeyClass());
                    String tempAlias = foreignKeyTableName.substring(0, 1) + ++aliasCounter;
                    ForeignKeyEntity.JoinTypes joinType = field.getAnnotation(ForeignKeyEntity.class).joinType();
                    fields.add(new ForeignKeyReference(tableModule.getTableName(instanceClass), alias, field, foreignKeyTableName, tempAlias, joinType));
                    Field foreignKeyField = Utilities.tryGetValue(() -> ((ForeignKeyPath)foreignKeyPathInfo.getAnnotation()).foreignKeyClass().getDeclaredField(((ForeignKeyPath)foreignKeyPathInfo.getAnnotation()).value()));
                    fields.add(new TableColumnReference(foreignKeyTableName, tempAlias, foreignKeyField));
                    continue;
                }
                String tempAlias = tableModule.getTableName(field.getType()).substring(0, 1) + ++aliasCounter;
                ForeignKeyEntity.JoinTypes joinType = field.getAnnotation(ForeignKeyEntity.class).joinType();
                fields.add(new ForeignKeyReference(tableModule.getTableName(instanceClass), alias, field, tableModule.getTableName(field.getType()), tempAlias, joinType));
                fields.addAll(this.getColumnReferences(field.getType(), tempAlias, aliasCounter++));
                continue;
            }
            fields.add(new TableColumnReference(tableModule.getTableName(instanceClass), alias, field));
        }
        return fields;
    }

    public List<Field> getAllFields(Class<?> clazz) {
        LinkedList<Field> list = new LinkedList<Field>();
        do {
            Arrays.stream(clazz.getDeclaredFields()).filter(x -> x.getAnnotation(Ignore.class) == null && !Modifier.isTransient(x.getModifiers())).forEach(list::add);
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return list;
    }

    public Map<String, String> getAliases(Class<? extends BaseEntity> clazz) {
        return this.getColumnReferences(clazz).stream().filter(x -> x instanceof ForeignKeyReference).map(ForeignKeyReference.class::cast).collect(Collectors.toMap(f -> f.getColumn().getDeclaringClass().getSimpleName().toLowerCase() + "_" + f.getColumn().getName(), ForeignKeyReference::getForeignKeyAlias));
    }
}

