/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.queries.ordering.OrderByClause;
import com.github.collinalpert.java2db.queries.ordering.OrderTypes;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.util.Collections;
import java.util.List;

public class QueryParameters<E extends BaseEntity> {
    private SqlPredicate<E> whereClause;
    private OrderTypes orderType;
    private OrderByClause<E> orderByClause;
    private List<SqlFunction<E, ?>> groupByClause;
    private Integer limit;
    private int limitOffset;
    private boolean distinct;

    public SqlPredicate<E> getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(SqlPredicate<E> whereClause) {
        this.whereClause = whereClause;
    }

    public void appendLogicalAndWhereClause(SqlPredicate<E> predicate) {
        this.whereClause = this.whereClause == null ? predicate : this.whereClause.and(predicate);
    }

    public void appendLogicalOrWhereClause(SqlPredicate<E> predicate) {
        this.whereClause = this.whereClause == null ? predicate : this.whereClause.or(predicate);
    }

    public OrderTypes getOrderType() {
        return this.orderType;
    }

    public void setOrderType(OrderTypes orderType) {
        this.orderType = orderType;
    }

    public OrderByClause<E> getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(SqlFunction<E, ?> orderByColumn, OrderTypes orderType) {
        this.orderByClause = new OrderByClause<E>(orderByColumn, orderType);
    }

    public void setOrderByClause(List<SqlFunction<E, ?>> orderByColumns, OrderTypes orderType) {
        this.orderByClause = new OrderByClause<E>(orderByColumns, orderType);
    }

    public void addOrderByColumns(SqlFunction<E, ?> orderByColumn, OrderTypes orderType) {
        try {
            this.orderByClause.addStatement(orderByColumn, orderType);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Please use the '.orderBy' method before using the '.thenBy' method.", e);
        }
    }

    public void addOrderByColumns(List<SqlFunction<E, ?>> orderByColumns, OrderTypes orderType) {
        try {
            this.orderByClause.addStatement(orderByColumns, orderType);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Please use the '.orderBy' method before using the '.thenBy' method.", e);
        }
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public int getLimitOffset() {
        return this.limitOffset;
    }

    public void setLimitOffset(int limitOffset) {
        this.limitOffset = limitOffset;
    }

    public List<SqlFunction<E, ?>> getGroupByClause() {
        return this.groupByClause;
    }

    public void setGroupBy(SqlFunction<E, ?> groupBy) {
        this.groupByClause = Collections.singletonList(groupBy);
    }

    public void setGroupBy(List<SqlFunction<E, ?>> groupBy) {
        this.groupByClause = groupBy;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public void setDistinct() {
        this.distinct = true;
    }
}

