/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.BinaryExpression;
import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.InvocationExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.MemberExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.TypeConverter;
import com.trigersoft.jaque.expression.UnaryExpression;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Expression {
    private final int _expressionType;
    private final Class<?> _resultType;
    private static final HashMap<Method, Class<?>> _boxers;
    private static final HashMap<Method, Class<?>> _unboxers;

    private boolean isNumeric() {
        return Expression.isNumeric(this.getResultType());
    }

    private boolean isIntegral() {
        return Expression.isIntegral(this.getResultType());
    }

    private static boolean isNumeric(Class<?> type) {
        if (Expression.isIntegral(type)) {
            return true;
        }
        if (type.isPrimitive()) {
            return type == Float.TYPE || type == Double.TYPE;
        }
        return type == Float.class || type == Double.class || type == BigDecimal.class;
    }

    private static boolean isIntegral(Class<?> type) {
        if (!type.isPrimitive()) {
            return type == Byte.class || type == Integer.class || type == Long.class || type == Short.class || type == BigInteger.class;
        }
        return type == Byte.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE;
    }

    private boolean isBoolean() {
        return Expression.isBoolean(this.getResultType());
    }

    private static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    private static Expression stripQuotesAndConverts(Expression e) {
        while (e.getExpressionType() == 32 || e.getExpressionType() == 8) {
            e = ((UnaryExpression)e).getFirst();
        }
        return e;
    }

    public final int getExpressionType() {
        return this._expressionType;
    }

    public final Class<?> getResultType() {
        return this._resultType;
    }

    protected Expression(int expressionType, Class<?> resultType) {
        if (resultType == null) {
            throw new NullPointerException("resultType");
        }
        this._expressionType = expressionType;
        this._resultType = resultType;
    }

    public static BinaryExpression add(Expression first, Expression second) {
        return Expression.createNumeric(0, first, second);
    }

    public static BinaryExpression divide(Expression first, Expression second) {
        return Expression.createNumeric(9, first, second);
    }

    public static BinaryExpression subtract(Expression first, Expression second) {
        return Expression.createNumeric(34, first, second);
    }

    public static BinaryExpression multiply(Expression first, Expression second) {
        return Expression.createNumeric(23, first, second);
    }

    public static BinaryExpression modulo(Expression first, Expression second) {
        return Expression.createNumeric(22, first, second);
    }

    public static BinaryExpression greaterThan(Expression first, Expression second) {
        return Expression.createNumericComparison(12, first, second);
    }

    public static BinaryExpression greaterThanOrEqual(Expression first, Expression second) {
        return Expression.createNumericComparison(13, first, second);
    }

    public static BinaryExpression lessThan(Expression first, Expression second) {
        return Expression.createNumericComparison(18, first, second);
    }

    public static BinaryExpression lessThanOrEqual(Expression first, Expression second) {
        return Expression.createNumericComparison(19, first, second);
    }

    private static BinaryExpression createNumericComparison(int expressionType, Expression first, Expression second) {
        if (!first.isNumeric()) {
            throw new IllegalArgumentException(first.getResultType().toString());
        }
        if (!second.isNumeric()) {
            throw new IllegalArgumentException(second.getResultType().toString());
        }
        return new BinaryExpression(expressionType, Boolean.TYPE, null, first, second);
    }

    private static BinaryExpression createNumeric(int expressionType, Expression first, Expression second) {
        boolean fnumeric = first.isNumeric();
        boolean snumeric = second.isNumeric();
        if (!fnumeric || !snumeric) {
            if (!fnumeric && !snumeric) {
                throw new IllegalArgumentException("At least one argument must be numeric, got: " + first.getResultType().toString() + "," + second.getResultType().toString());
            }
            if (!fnumeric) {
                first = TypeConverter.convert(first, second.getResultType());
            } else {
                second = TypeConverter.convert(second, first.getResultType());
            }
        }
        return new BinaryExpression(expressionType, first.getResultType(), null, first, second);
    }

    private static BinaryExpression createIntegral(int expressionType, Expression first, Expression second) {
        if (!first.isIntegral()) {
            throw new IllegalArgumentException(first.getResultType().toString());
        }
        if (!second.isIntegral()) {
            throw new IllegalArgumentException(second.getResultType().toString());
        }
        return new BinaryExpression(expressionType, first.getResultType(), null, first, second);
    }

    public static BinaryExpression leftShift(Expression first, Expression second) {
        return Expression.createIntegral(17, first, second);
    }

    public static BinaryExpression rightShift(Expression first, Expression second) {
        return Expression.createIntegral(33, first, second);
    }

    public static BinaryExpression coalesce(Expression first, Expression second) {
        if (first.getResultType().isPrimitive()) {
            throw new IllegalArgumentException(first.getResultType().toString());
        }
        if (second.getResultType().isPrimitive()) {
            throw new IllegalArgumentException(second.getResultType().toString());
        }
        return new BinaryExpression(5, first.getResultType(), null, first, second);
    }

    public static Expression equal(Expression first, Expression second) {
        if (first.getResultType() != second.getResultType()) {
            throw new IllegalArgumentException(first.getResultType().toString() + " != " + second.getResultType().toString());
        }
        return Expression.createBooleanExpression(10, first, second);
    }

    public static Expression notEqual(Expression first, Expression second) {
        if (first.getResultType() != second.getResultType()) {
            throw new IllegalArgumentException(first.getResultType().toString() + " != " + second.getResultType().toString());
        }
        return Expression.createBooleanExpression(28, first, second);
    }

    public static Expression logicalAnd(Expression first, Expression second) {
        if (!first.isBoolean()) {
            throw new IllegalArgumentException(first.getResultType().toString());
        }
        if (!second.isBoolean()) {
            throw new IllegalArgumentException(second.getResultType().toString());
        }
        return Expression.createBooleanExpression(2, first, second);
    }

    public static BinaryExpression bitwiseAnd(Expression first, Expression second) {
        return Expression.createIntegral(1, first, second);
    }

    public static Expression logicalOr(Expression first, Expression second) {
        if (!first.isBoolean()) {
            throw new IllegalArgumentException(first.getResultType().toString());
        }
        if (!second.isBoolean()) {
            throw new IllegalArgumentException(second.getResultType().toString());
        }
        return Expression.createBooleanExpression(30, first, second);
    }

    public static BinaryExpression bitwiseOr(Expression first, Expression second) {
        return Expression.createIntegral(29, first, second);
    }

    public static Expression exclusiveOr(Expression first, Expression second) {
        ConstantExpression csecond;
        if (second.getExpressionType() == 7 && Expression.isIntegral((csecond = (ConstantExpression)second).getResultType()) && ((Number)csecond.getValue()).intValue() == -1) {
            return Expression.bitwiseNot(first);
        }
        return Expression.createIntegral(11, first, second);
    }

    public static UnaryExpression arrayLength(Expression array) {
        if (!array.getResultType().isArray()) {
            throw new IllegalArgumentException(array.getResultType().toString());
        }
        return new UnaryExpression(4, Integer.TYPE, array);
    }

    public static BinaryExpression arrayIndex(Expression array, Expression index) {
        Class<?> arrayType = array.getResultType();
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException(arrayType.toString());
        }
        if (index.getResultType() != Integer.TYPE) {
            throw new IllegalArgumentException("index:" + index.getResultType().toString());
        }
        return new BinaryExpression(3, arrayType.getComponentType(), null, array, index);
    }

    public static Expression convert(Expression e, Class<?> to) {
        if (e.getResultType() == to) {
            return e;
        }
        return new UnaryExpression(8, to, e);
    }

    public static ConstantExpression constant(Object value, Class<?> resultType) {
        return new ConstantExpression(resultType, value);
    }

    public static UnaryExpression quote(Expression e) {
        Class<Object> result;
        if (e instanceof LambdaExpression) {
            switch (((LambdaExpression)e).getParameters().size()) {
                case 0: {
                    result = Supplier.class;
                    break;
                }
                default: {
                    result = Function.class;
                    break;
                }
                case 2: {
                    result = BiFunction.class;
                    break;
                }
            }
        } else {
            result = e.getResultType();
        }
        return new UnaryExpression(32, result, e);
    }

    public static ConstantExpression constant(Object value) {
        Class type = value == null ? Object.class : value.getClass();
        return Expression.constant(value, type);
    }

    public static UnaryExpression negate(Expression e) {
        if (!e.isNumeric()) {
            throw new IllegalArgumentException(e.getResultType().toString());
        }
        return new UnaryExpression(24, e.getResultType(), e);
    }

    public static ParameterExpression parameter(Class<?> resultType, int index) {
        return new ParameterExpression(resultType, index);
    }

    public static BinaryExpression instanceOf(Expression e, Class<?> type) {
        return Expression.instanceOf(e, Expression.constant(type));
    }

    public static BinaryExpression instanceOf(Expression e, Expression type) {
        return new BinaryExpression(35, Boolean.TYPE, null, e, type);
    }

    public static Expression unary(int expressionType, Class<?> resultType, Expression operand) {
        switch (expressionType) {
            case 8: {
                return Expression.convert(operand, resultType);
            }
            case 4: {
                return Expression.arrayLength(operand);
            }
            case 24: {
                return Expression.negate(operand);
            }
            case 26: {
                return Expression.bitwiseNot(operand);
            }
            case 27: {
                return Expression.logicalNot(operand);
            }
            case 32: {
                return Expression.quote(operand);
            }
            case 15: {
                return Expression.isNull(operand);
            }
        }
        throw new IllegalArgumentException("expressionType");
    }

    public static Expression binary(int expressionType, Expression first, Expression second) {
        return Expression.binary(expressionType, null, first, second);
    }

    public static Expression binary(int expressionType, Expression operator, Expression first, Expression second) {
        switch (expressionType) {
            case 0: {
                return Expression.add(first, second);
            }
            case 1: {
                return Expression.bitwiseAnd(first, second);
            }
            case 2: {
                return Expression.logicalAnd(first, second);
            }
            case 3: {
                return Expression.arrayIndex(first, second);
            }
            case 5: {
                return Expression.coalesce(first, second);
            }
            case 6: {
                return Expression.condition(operator, first, second);
            }
            case 9: {
                return Expression.divide(first, second);
            }
            case 10: {
                return Expression.equal(first, second);
            }
            case 11: {
                return Expression.exclusiveOr(first, second);
            }
            case 12: {
                return Expression.greaterThan(first, second);
            }
            case 13: {
                return Expression.greaterThanOrEqual(first, second);
            }
            case 17: {
                return Expression.leftShift(first, second);
            }
            case 18: {
                return Expression.lessThan(first, second);
            }
            case 19: {
                return Expression.lessThanOrEqual(first, second);
            }
            case 22: {
                return Expression.modulo(first, second);
            }
            case 23: {
                return Expression.multiply(first, second);
            }
            case 28: {
                return Expression.notEqual(first, second);
            }
            case 29: {
                return Expression.bitwiseOr(first, second);
            }
            case 30: {
                return Expression.logicalOr(first, second);
            }
            case 33: {
                return Expression.rightShift(first, second);
            }
            case 34: {
                return Expression.subtract(first, second);
            }
            case 35: {
                return Expression.instanceOf(first, second);
            }
        }
        throw new IllegalArgumentException("expressionType");
    }

    private static Expression createBooleanExpression(int expressionType, Expression first, Expression second) {
        Expression toLeave;
        Expression toReduce;
        if (first.getExpressionType() == 7) {
            toReduce = first;
            toLeave = second;
        } else if (second.getExpressionType() == 7) {
            toReduce = second;
            toLeave = first;
        } else {
            toReduce = null;
            toLeave = null;
        }
        if (toLeave != null && toLeave.isBoolean()) {
            toReduce = TypeConverter.convert(toReduce, Boolean.TYPE);
            switch (expressionType) {
                case 10: {
                    return (Boolean)((ConstantExpression)toReduce).getValue() != false ? toLeave : Expression.logicalNot(toLeave);
                }
                case 28: {
                    return (Boolean)((ConstantExpression)toReduce).getValue() != false ? Expression.logicalNot(toLeave) : toLeave;
                }
                case 2: {
                    return (Boolean)((ConstantExpression)toReduce).getValue() != false ? toLeave : toReduce;
                }
                case 30: {
                    return (Boolean)((ConstantExpression)toReduce).getValue() != false ? toReduce : toLeave;
                }
            }
        }
        return new BinaryExpression(expressionType, Boolean.TYPE, null, first, second);
    }

    public static LambdaExpression<?> lambda(Class<?> resultType, Expression body, List<ParameterExpression> arguments) {
        return new LambdaExpression(resultType, body, arguments);
    }

    public static InvocationExpression get(Class<?> type, String name) throws NoSuchFieldException {
        return Expression.get(null, type.getDeclaredField(name));
    }

    public static InvocationExpression get(Expression instance, String name) throws NoSuchFieldException {
        return Expression.get(instance, instance.getResultType().getDeclaredField(name));
    }

    public static MemberExpression member(int expressionType, Expression instance, Member member, Class<?> resultType, List<ParameterExpression> params) {
        return new MemberExpression(expressionType, instance, member, resultType, params);
    }

    public static InvocationExpression get(Expression instance, Field field) {
        return Expression.invoke((InvocableExpression)Expression.member(20, instance, field, field.getType(), Collections.emptyList()), Collections.singletonList(instance));
    }

    public static Expression invoke(Expression instance, Method method, Expression ... arguments) {
        return Expression.invoke(instance, method, Collections.unmodifiableList(Arrays.asList(arguments)));
    }

    public static Expression invoke(Expression instance, Method method, List<Expression> arguments) {
        Class<?> boxer;
        Expression e;
        if (instance != null) {
            Class<?> primitive;
            if (!instance.getResultType().isPrimitive() && (primitive = _unboxers.get(method)) != null) {
                return Expression.convert(instance, primitive);
            }
            if (instance.getExpressionType() == 31) {
                arguments = new ArrayList<Expression>(arguments);
                int index = arguments.size();
                arguments.add(instance);
                instance = Expression.parameter(instance.getResultType(), index);
            }
        } else if (arguments.size() == 1 && (e = arguments.get(0)).getResultType().isPrimitive() && (boxer = _boxers.get(method)) != null) {
            return Expression.convert(e, boxer);
        }
        return Expression.invoke((InvocableExpression)Expression.member(21, instance, method, method.getReturnType(), Expression.getParameters(method)), arguments);
    }

    public static InvocationExpression invoke(InvocableExpression method, Expression ... arguments) {
        return Expression.invoke(method, Arrays.asList(arguments));
    }

    public static InvocationExpression invoke(InvocableExpression method, List<Expression> arguments) {
        return new InvocationExpression(method, arguments);
    }

    private static List<ParameterExpression> getParameters(Member member) {
        Class<?>[] params;
        if (member instanceof Constructor) {
            Constructor ctor = (Constructor)member;
            params = ctor.getParameterTypes();
        } else {
            Method m = (Method)member;
            params = m.getParameterTypes();
        }
        ArrayList<ParameterExpression> plist = new ArrayList<ParameterExpression>(params.length);
        for (int i = 0; i < params.length; ++i) {
            plist.add(Expression.parameter(params[i], i));
        }
        return Collections.unmodifiableList(plist);
    }

    public static InvocationExpression newInstance(Constructor<?> method, Expression ... arguments) {
        return Expression.newInstance(method, Collections.unmodifiableList(Arrays.asList(arguments)));
    }

    public static InvocationExpression newInstance(Constructor<?> method, List<Expression> arguments) {
        return Expression.invoke((InvocableExpression)Expression.member(25, null, method, method.getDeclaringClass(), Expression.getParameters(method)), arguments);
    }

    public static InvocationExpression newInstance(Class<?> type, Class<?>[] argumentTypes, Expression ... arguments) throws NoSuchMethodException {
        return Expression.newInstance(type.getConstructor(argumentTypes), arguments);
    }

    public static Expression invoke(Expression instance, String name, Class<?>[] parameterTypes, Expression ... arguments) throws NoSuchMethodException {
        return Expression.invoke(instance, Expression.getDeclaredMethod(instance.getResultType(), name, parameterTypes), arguments);
    }

    public static Expression invoke(Class<?> type, String name, Class<?>[] parameterTypes, Expression ... arguments) throws NoSuchMethodException {
        return Expression.invoke(null, Expression.getDeclaredMethod(type, name, parameterTypes), arguments);
    }

    private static Method getDeclaredMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Class<?> tmpClass = clazz;
        while (true) {
            try {
                return tmpClass.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                Class<?> thisClass;
                if ((tmpClass = (thisClass = tmpClass).getSuperclass()) != null) continue;
                return thisClass.getMethod(name, parameterTypes);
            }
            break;
        }
    }

    public static Expression condition(Expression test, Expression ifTrue, Expression ifFalse) {
        if (!test.isBoolean()) {
            throw new IllegalArgumentException("test is " + test.getResultType());
        }
        if (ifTrue.isBoolean()) {
            Expression ifTrueStripped = Expression.stripQuotesAndConverts(ifTrue);
            Expression ifFalseStripped = Expression.stripQuotesAndConverts(ifFalse);
            if (ifTrueStripped.getExpressionType() == 7 && ifFalseStripped.getExpressionType() == 7) {
                ConstantExpression cfirst = (ConstantExpression)ifTrueStripped;
                ConstantExpression csecond = (ConstantExpression)ifFalseStripped;
                if (cfirst.getValue().equals(csecond.getValue())) {
                    return ifTrue;
                }
                return Expression.convert((Boolean)cfirst.getValue() != false ? test : Expression.logicalNot(test), ifTrue.getResultType());
            }
        }
        return new BinaryExpression(6, ifTrue.getResultType(), test, ifTrue, ifFalse);
    }

    public static UnaryExpression isNull(Expression e) {
        if (e.getResultType().isPrimitive()) {
            throw new IllegalArgumentException(e.getResultType().toString());
        }
        return new UnaryExpression(15, Boolean.TYPE, e);
    }

    public static UnaryExpression bitwiseNot(Expression e) {
        if (!e.isIntegral()) {
            throw new IllegalArgumentException(e.getResultType().toString());
        }
        return new UnaryExpression(26, e.getResultType(), e);
    }

    public static Expression logicalNot(Expression e) {
        int type;
        if (!e.isBoolean()) {
            throw new IllegalArgumentException(e.getResultType().toString());
        }
        switch (e.getExpressionType()) {
            case 6: {
                BinaryExpression be = (BinaryExpression)e;
                return Expression.condition(be.getOperator(), Expression.logicalNot(be.getFirst()), Expression.logicalNot(be.getSecond()));
            }
            case 7: {
                ConstantExpression ce = (ConstantExpression)e;
                return Expression.constant((Boolean)ce.getValue() == false, ce.getResultType());
            }
            case 27: {
                UnaryExpression ue = (UnaryExpression)e;
                return ue.getFirst();
            }
            case 2: {
                BinaryExpression be = (BinaryExpression)e;
                return Expression.convert(Expression.logicalOr(Expression.logicalNot(be.getFirst()), Expression.logicalNot(be.getSecond())), be.getResultType());
            }
            case 30: {
                BinaryExpression be = (BinaryExpression)e;
                return Expression.convert(Expression.logicalAnd(Expression.logicalNot(be.getFirst()), Expression.logicalNot(be.getSecond())), be.getResultType());
            }
            case 10: {
                type = 28;
                break;
            }
            case 12: {
                type = 19;
                break;
            }
            case 13: {
                type = 18;
                break;
            }
            case 18: {
                type = 13;
                break;
            }
            case 19: {
                type = 12;
                break;
            }
            case 28: {
                type = 10;
                break;
            }
            default: {
                return new UnaryExpression(27, e.getResultType(), e);
            }
        }
        BinaryExpression be = (BinaryExpression)e;
        return Expression.binary(type, be.getFirst(), be.getSecond());
    }

    public final <T> T accept(ExpressionVisitor<T> v) {
        return this.visit(v);
    }

    protected abstract <T> T visit(ExpressionVisitor<T> var1);

    public int hashCode() {
        return this._expressionType ^ this._resultType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)obj;
        return this._expressionType == other._expressionType && this._resultType == other._resultType;
    }

    static {
        HashMap<Method, Class<Comparable<Boolean>>> unboxers = new HashMap<Method, Class<Comparable<Boolean>>>(8);
        try {
            unboxers.put(Boolean.class.getMethod("booleanValue", new Class[0]), Boolean.TYPE);
            unboxers.put(Byte.class.getMethod("byteValue", new Class[0]), Byte.TYPE);
            unboxers.put(Character.class.getMethod("charValue", new Class[0]), Character.TYPE);
            unboxers.put(Double.class.getMethod("doubleValue", new Class[0]), Double.TYPE);
            unboxers.put(Float.class.getMethod("floatValue", new Class[0]), Float.TYPE);
            unboxers.put(Integer.class.getMethod("intValue", new Class[0]), Integer.TYPE);
            unboxers.put(Long.class.getMethod("longValue", new Class[0]), Long.TYPE);
            unboxers.put(Short.class.getMethod("shortValue", new Class[0]), Short.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        HashMap<Method, Class> boxers = new HashMap<Method, Class>(8);
        try {
            boxers.put(Boolean.class.getMethod("valueOf", Boolean.TYPE), Boolean.class);
            boxers.put(Byte.class.getMethod("valueOf", Byte.TYPE), Byte.class);
            boxers.put(Character.class.getMethod("valueOf", Character.TYPE), Character.class);
            boxers.put(Double.class.getMethod("valueOf", Double.TYPE), Double.class);
            boxers.put(Float.class.getMethod("valueOf", Float.TYPE), Float.class);
            boxers.put(Integer.class.getMethod("valueOf", Integer.TYPE), Integer.class);
            boxers.put(Long.class.getMethod("valueOf", Long.TYPE), Long.class);
            boxers.put(Short.class.getMethod("valueOf", Short.TYPE), Short.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        _unboxers = unboxers;
        _boxers = boxers;
    }
}

