/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.codedict.core;

import com.github.cosycode.codedict.core.IDictItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DictItems {
    private static final String SPLIT_SYMBOL = ",";

    private DictItems() {
    }

    public static <T extends IDictItem> T getByValue(Class<T> enumClass, String value) {
        if (enumClass == null) {
            return null;
        }
        for (IDictItem each : (IDictItem[])enumClass.getEnumConstants()) {
            if (!value.equals(each.value())) continue;
            return (T)each;
        }
        return null;
    }

    public static <T extends IDictItem> T getByLabel(Class<T> enumClass, String label) {
        if (enumClass == null) {
            return null;
        }
        for (IDictItem each : (IDictItem[])enumClass.getEnumConstants()) {
            if (!label.trim().equals(each.label())) continue;
            return (T)each;
        }
        return null;
    }

    public static <T extends IDictItem> String getLabelByValue(Class<T> enumClass, String value) {
        if (value == null) {
            return "";
        }
        T byValue = DictItems.getByValue(enumClass, value);
        if (null == byValue) {
            return value;
        }
        return byValue.label();
    }

    public static <T extends IDictItem> String getValueByLabel(Class<T> enumClass, String label) {
        if (label == null) {
            return "";
        }
        T byValue = DictItems.getByLabel(enumClass, label = label.trim());
        if (null == byValue) {
            return label;
        }
        return byValue.value();
    }

    public static <T extends IDictItem> List<T> getByValueForMulti(Class<T> enumClass, String value) {
        if (enumClass == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        String[] arr = value.split(SPLIT_SYMBOL);
        ArrayList<IDictItem> list = new ArrayList<IDictItem>(arr.length);
        block0: for (String str : arr) {
            for (IDictItem each : (IDictItem[])enumClass.getEnumConstants()) {
                if (!str.equals(each.value())) continue;
                list.add(each);
                continue block0;
            }
        }
        return list;
    }

    public static <T extends IDictItem> List<T> getByLabelForMulti(Class<T> enumClass, String label) {
        if (enumClass == null || label.isEmpty()) {
            return Collections.emptyList();
        }
        String[] arr = label.split(SPLIT_SYMBOL);
        ArrayList<IDictItem> list = new ArrayList<IDictItem>(arr.length);
        block0: for (String str : arr) {
            for (IDictItem each : (IDictItem[])enumClass.getEnumConstants()) {
                if (!str.equals(each.label())) continue;
                list.add(each);
                continue block0;
            }
        }
        return list;
    }

    public static <T extends IDictItem> String getLabelByValueForMulti(Class<T> enumClass, String value) {
        if (value == null) {
            return "";
        }
        List<T> list = DictItems.getByValueForMulti(enumClass, value);
        if (list.isEmpty()) {
            return value;
        }
        return list.stream().map(IDictItem::label).collect(Collectors.joining(SPLIT_SYMBOL));
    }

    public static <T extends IDictItem> String getValueByLabelForMulti(Class<T> enumClass, String label) {
        if (label == null) {
            return "";
        }
        List<T> list = DictItems.getByLabelForMulti(enumClass, label);
        if (list.isEmpty()) {
            return label;
        }
        return list.stream().map(IDictItem::value).collect(Collectors.joining(SPLIT_SYMBOL));
    }
}

