/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import configuration.ClassProvider;
import configuration.DefaultAdjusters;
import configuration.JavaForgerConfiguration;

public class DefaultConfigurations {
    public static JavaForgerConfiguration forEquals() {
        return DefaultConfigurations.defaultConfig("equals.javat");
    }

    public static JavaForgerConfiguration forEqualsAndTest() {
        return DefaultConfigurations.defaultConfiguration("equals.javat", "equalsTest.javat");
    }

    public static JavaForgerConfiguration forHashCode() {
        return DefaultConfigurations.defaultConfig("hashCode.javat");
    }

    public static JavaForgerConfiguration forHashCodeAndTest() {
        return DefaultConfigurations.defaultConfiguration("hashCode.javat", "hashCodeTest.javat");
    }

    public static JavaForgerConfiguration forBuilder() {
        JavaForgerConfiguration config = DefaultConfigurations.defaultConfig("innerBuilder.javat");
        config.addParameterAdjusters(DefaultAdjusters.replaceFieldPrimitivesWithObjects());
        return config;
    }

    public static JavaForgerConfiguration forBuilderAndTest() {
        JavaForgerConfiguration config = DefaultConfigurations.defaultConfiguration("innerBuilder.javat", "innerBuilderTest.javat");
        config.addParameterAdjusters(DefaultAdjusters.replaceFieldPrimitivesWithObjects());
        return config;
    }

    public static JavaForgerConfiguration forExtendableBuilderAndTest() {
        JavaForgerConfiguration config = DefaultConfigurations.defaultConfiguration("extendableInnerBuilder.javat", "innerBuilderTest.javat");
        config.addParameterAdjusters(DefaultAdjusters.replaceFieldPrimitivesWithObjects());
        return config;
    }

    public static JavaForgerConfiguration forToString() {
        return DefaultConfigurations.defaultConfig("toString/complete.javat");
    }

    protected static JavaForgerConfiguration defaultConfig(String template) {
        return DefaultConfigurations.defaultBuilder(template).build();
    }

    protected static JavaForgerConfiguration defaultConfiguration(String template, String testTemplate) {
        return DefaultConfigurations.defaultBuilder(template).withChildConfig(DefaultConfigurations.defaultBuilder(testTemplate).withMergeClassProvider(ClassProvider.forMavenUnitTestFromInput()).build()).build();
    }

    protected static JavaForgerConfiguration.Builder defaultBuilder(String template) {
        return JavaForgerConfiguration.builder().withTemplate(template).withMergeClassProvider(new ClassProvider()).withParameterAdjusters(DefaultAdjusters.removeDepracatedFields(), DefaultAdjusters.removeStaticFields());
    }
}

