/*
 * Decompiled with CFR 0.152.
 */
package merger;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.expr.SimpleName;
import generator.JavaForgerException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import merger.CodeSnipitLocation;
import merger.NodeComparator;

public class CodeSnipitLocater {
    NodeComparator comparator = new NodeComparator();

    public LinkedHashMap<CodeSnipitLocation, CodeSnipitLocation> locate(CompilationUnit existingCode, Node newCode) {
        LinkedHashMap locations = this.recursiveLocator(existingCode.getChildNodes(), newCode.getChildNodes());
        locations = locations.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
        return locations;
    }

    protected LinkedHashMap<CodeSnipitLocation, CodeSnipitLocation> recursiveLocator(List<Node> existingNodes, List<Node> insertNodes) {
        LinkedHashMap<CodeSnipitLocation, CodeSnipitLocation> locations = new LinkedHashMap<CodeSnipitLocation, CodeSnipitLocation>();
        int insertAfter = -1;
        List supportedInsertNodes = insertNodes.stream().filter(this.comparator::nodeTypeIsSupported).collect(Collectors.toList());
        for (Node insertNode : supportedInsertNodes) {
            int equalNodeIndex = this.findEqualNode(existingNodes, insertNode);
            if (equalNodeIndex >= 0) {
                locations.putAll(this.handleEqualNodesRecursively(insertNode, existingNodes.get(equalNodeIndex)));
                insertAfter = Integer.max(insertAfter, equalNodeIndex);
                continue;
            }
            if ((insertAfter = this.findInsertAfterIndex(existingNodes, insertAfter, insertNode)) < 0) {
                locations.put(CodeSnipitLocation.of(insertNode), CodeSnipitLocation.before(existingNodes.get(0)));
                continue;
            }
            locations.put(CodeSnipitLocation.of(insertNode), CodeSnipitLocation.after(existingNodes.get(insertAfter)));
        }
        return locations;
    }

    private LinkedHashMap<CodeSnipitLocation, CodeSnipitLocation> handleEqualNodesRecursively(Node insertNode, Node existingNode) {
        LinkedHashMap loc = new LinkedHashMap();
        if (this.isClass(existingNode) && this.isClass(insertNode)) {
            List<Node> insertNodes = this.getChildNodes(insertNode);
            List<Node> existingNodes = this.getChildNodes(existingNode);
            if (!insertNodes.isEmpty()) {
                if (existingNodes.isEmpty()) {
                    CodeSnipitLocation firstInsertLocation = this.getFirstInsertLocation((ClassOrInterfaceDeclaration)existingNode);
                    loc = insertNodes.stream().collect(Collectors.toMap(CodeSnipitLocation::of, c -> firstInsertLocation, (a, b) -> a, LinkedHashMap::new));
                } else {
                    loc = this.recursiveLocator(existingNodes, insertNodes);
                }
            }
        } else {
            loc.put(CodeSnipitLocation.of(insertNode), CodeSnipitLocation.of(existingNode));
        }
        return loc;
    }

    private CodeSnipitLocation getFirstInsertLocation(ClassOrInterfaceDeclaration existingNode) {
        return CodeSnipitLocation.after(this.getNodeAfterToInsert(existingNode));
    }

    private Node getNodeAfterToInsert(ClassOrInterfaceDeclaration existingNode) {
        return existingNode.getChildNodes().stream().filter(node -> SimpleName.class.isAssignableFrom(node.getClass())).findFirst().orElseThrow(() -> new JavaForgerException("Cannot insert code into a class without a simpleName defined. Existing node is: " + existingNode.toString()));
    }

    private boolean isClass(Node existingNode) {
        return ClassOrInterfaceDeclaration.class.isAssignableFrom(existingNode.getClass());
    }

    private List<Node> getChildNodes(Node node) {
        return node.getChildNodes().stream().filter(this.comparator::nodeTypeIsSupported).collect(Collectors.toList());
    }

    private int findEqualNode(List<Node> existingNodes, Node insertNode) {
        int index = 0;
        while (index < existingNodes.size()) {
            if (this.comparator.compare(existingNodes.get(index), insertNode) == 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int findInsertAfterIndex(List<Node> existingNodes, int previousIndex, Node insertNode) {
        int index = previousIndex;
        int compare = this.comparator.compare(existingNodes.get(Integer.max(0, index)), insertNode);
        while (compare < 0 && index < existingNodes.size() - 1) {
            compare = this.comparator.compare(existingNodes.get(index + 1), insertNode);
            if (compare >= 0) continue;
            ++index;
        }
        return index;
    }
}

