/*
 * Decompiled with CFR 0.152.
 */
package merger;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import configuration.JavaForgerConfiguration;
import generator.CodeSnipit;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import merger.CodeSnipitMerger;
import merger.CodeSnipitReader;

public class JavaParserMerger
extends CodeSnipitMerger {
    private CodeSnipitReader reader = new CodeSnipitReader();

    @Override
    protected void executeMerge(JavaForgerConfiguration config, CodeSnipit codeSnipit, String mergeClassPath) throws IOException {
        CompilationUnit existingCode = this.reader.read(mergeClassPath);
        String completeClass = this.reader.toCompleteClass(codeSnipit, mergeClassPath);
        CompilationUnit newCode = this.reader.readClass(completeClass);
        this.merge(existingCode, newCode);
        this.write(mergeClassPath, existingCode);
    }

    private void merge(CompilationUnit existingCode, CompilationUnit newCode) {
        this.mergeImports(existingCode, newCode);
        NodeList existingMembers = this.getParent(existingCode).getMembers();
        NodeList newMembers = this.getParent(newCode).getMembers();
        for (BodyDeclaration member : newMembers) {
            int replacementIndex = this.findReplacementNode(existingMembers, member);
            if (replacementIndex >= 0) {
                existingMembers.set(replacementIndex, (Node)member);
                continue;
            }
            int insertIndex = this.findInsertionLocation(existingMembers, member);
            existingMembers.add(insertIndex, (Node)member);
        }
    }

    private void mergeImports(CompilationUnit existingCode, CompilationUnit newCode) {
        HashSet existingSet = new HashSet(existingCode.getImports());
        newCode.getImports().stream().filter(imp -> !existingSet.contains(imp)).forEach(t -> {
            existingCode.addImport(t);
            existingSet.add(t);
        });
    }

    private int findInsertionLocation(NodeList<BodyDeclaration<?>> existingMembers, BodyDeclaration<?> member) {
        int index = 0;
        int i = 0;
        while (i < existingMembers.size()) {
            if (((BodyDeclaration)existingMembers.get(i)).getClass().equals(member.getClass())) {
                Optional<EnumSet<Modifier>> modNew = this.findModifiers(member);
                Optional<EnumSet<Modifier>> modExist = this.findModifiers((BodyDeclaration)existingMembers.get(i));
                if (modNew.isPresent() && modExist.isPresent()) {
                    if (this.hasHigherPriorityModifier(modExist.get(), modNew.get())) {
                        index = i + 1;
                    }
                } else {
                    index = i + 1;
                }
            }
            ++i;
        }
        return index;
    }

    private boolean hasHigherPriorityModifier(EnumSet<Modifier> modExist, EnumSet<Modifier> modNew) {
        boolean hasHigherPrio = modExist.contains(Modifier.PUBLIC) ? true : (modExist.contains(Modifier.PROTECTED) ? !modNew.contains(Modifier.PUBLIC) && !this.isDefaultModifier(modNew) : (modExist.contains(Modifier.PRIVATE) ? modNew.contains(Modifier.PRIVATE) : !modNew.contains(Modifier.PUBLIC)));
        return hasHigherPrio;
    }

    private boolean isDefaultModifier(EnumSet<Modifier> modifiers) {
        return !modifiers.contains(Modifier.PUBLIC) && !modifiers.contains(Modifier.PROTECTED) && !modifiers.contains(Modifier.PRIVATE);
    }

    private Optional<EnumSet<Modifier>> findModifiers(BodyDeclaration<?> member) {
        EnumSet modifiers = null;
        if (FieldDeclaration.class.isAssignableFrom(member.getClass())) {
            FieldDeclaration d = (FieldDeclaration)member;
            modifiers = d.getModifiers();
        } else if (CallableDeclaration.class.isAssignableFrom(member.getClass())) {
            CallableDeclaration d = (CallableDeclaration)member;
            modifiers = d.getModifiers();
        } else if (TypeDeclaration.class.isAssignableFrom(member.getClass())) {
            TypeDeclaration d = (TypeDeclaration)member;
            modifiers = d.getModifiers();
        }
        return Optional.ofNullable(modifiers);
    }

    private int findReplacementNode(NodeList<BodyDeclaration<?>> existingMembers, BodyDeclaration<?> member) {
        int index = -1;
        int i = 0;
        while (i < existingMembers.size()) {
            BodyDeclaration exists = (BodyDeclaration)existingMembers.get(i);
            if (exists.getClass().equals(member.getClass()) && this.memberIsReplacement(exists, member)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private boolean memberIsReplacement(BodyDeclaration<?> exists, BodyDeclaration<?> member) {
        boolean isReplacement = false;
        if (MethodDeclaration.class.isAssignableFrom(member.getClass())) {
            MethodDeclaration m1 = (MethodDeclaration)exists;
            MethodDeclaration m2 = (MethodDeclaration)member;
            isReplacement = m1.getName().equals((Object)m2.getName());
            List parameterTypes1 = m1.getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
            List parameterTypes2 = m2.getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
            isReplacement = isReplacement && parameterTypes1.equals(parameterTypes2);
        } else if (FieldDeclaration.class.isAssignableFrom(member.getClass())) {
            FieldDeclaration f1 = (FieldDeclaration)exists;
            FieldDeclaration f2 = (FieldDeclaration)member;
            isReplacement = f1.getVariable(0).getName().asString().equals(f2.getVariable(0).getName().asString());
        } else if (ClassOrInterfaceDeclaration.class.isAssignableFrom(member.getClass())) {
            isReplacement = ((ClassOrInterfaceDeclaration)exists).getName().equals((Object)((ClassOrInterfaceDeclaration)member).getName());
        } else if (ConstructorDeclaration.class.isAssignableFrom(member.getClass())) {
            ConstructorDeclaration m1 = (ConstructorDeclaration)exists;
            ConstructorDeclaration m2 = (ConstructorDeclaration)member;
            isReplacement = m1.getName().equals((Object)m2.getName());
            List parameterTypes1 = m1.getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
            List parameterTypes2 = m2.getParameters().stream().map(p -> p.getType()).collect(Collectors.toList());
            isReplacement = isReplacement && parameterTypes1.equals(parameterTypes2);
        } else {
            System.err.println("The type " + member.getClass().getName() + " is currently not supported. This type will not be replaced if it already exists, it will be simply be added. ");
        }
        return isReplacement;
    }

    private ClassOrInterfaceDeclaration getParent(CompilationUnit cu) {
        ClassOrInterfaceDeclaration parentNode = null;
        for (TypeDeclaration type : cu.getTypes()) {
            if (!(type instanceof ClassOrInterfaceDeclaration)) continue;
            parentNode = (ClassOrInterfaceDeclaration)type;
            break;
        }
        if (parentNode == null) {
            System.err.println("Parent node was not found in Compilation Unit below:");
            System.err.println(cu.toString());
        }
        return parentNode;
    }

    protected void write(String className, CompilationUnit existingCode) throws IOException {
        String backupFile = this.readFile(className, StandardCharsets.UTF_8);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PrintWriter writer = new PrintWriter(className, "UTF-8");){
                this.write(existingCode, writer);
                writer.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Throwable throwable = null;
            Object var6_12 = null;
            try (PrintWriter writer2 = new PrintWriter(className, "UTF-8");){
                writer2.append(backupFile);
                writer2.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            e.printStackTrace();
        }
    }

    protected void write(CompilationUnit existingCode, PrintWriter writer) throws IOException {
        LexicalPreservingPrinter.print((Node)existingCode, (Writer)writer);
    }

    private String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }
}

