/*
 * Decompiled with CFR 0.152.
 */
package generator;

import configuration.ClassProvider;
import configuration.JavaForgerConfiguration;
import configuration.StaticJavaForgerConfiguration;
import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import generator.CodeSnipit;
import generator.JavaForgerException;
import generator.TemplateInputParametersService;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import merger.CodeSnipitMerger;
import templateInput.TemplateInputParameters;

public class Generator {
    private CodeSnipitMerger merger = StaticJavaForgerConfiguration.getMerger();
    private TemplateInputParametersService inputService = new TemplateInputParametersService();
    private StaticJavaForgerConfiguration staticConfig = StaticJavaForgerConfiguration.getConfig();

    public CodeSnipit execute(String template, TemplateInputParameters inputParameters) throws IOException, TemplateException {
        return this.execute(template, null, inputParameters);
    }

    public CodeSnipit execute(String template, String inputClass) throws IOException, TemplateException {
        return this.execute(template, inputClass, new TemplateInputParameters());
    }

    public CodeSnipit execute(String template, String inputClass, TemplateInputParameters inputParameters) throws IOException, TemplateException {
        return this.execute(JavaForgerConfiguration.builder().inputParameters(inputParameters).template(template).build(), inputClass);
    }

    public CodeSnipit execute(JavaForgerConfiguration genConfig) throws IOException, TemplateException {
        return this.execute(genConfig, "");
    }

    public CodeSnipit execute(JavaForgerConfiguration config, String inputClass) throws IOException, TemplateException {
        return this.execute(config, inputClass, null);
    }

    private CodeSnipit execute(JavaForgerConfiguration config, String inputClass, String parentMergeClass) throws IOException, TemplateException {
        String mergeClassPath = this.getMergeClass(inputClass, parentMergeClass, config);
        TemplateInputParameters inputParameters = this.inputService.getInputParameters(config, inputClass, mergeClassPath);
        CodeSnipit codeSnipit = this.processTemplate(config, inputParameters);
        this.merge(config, codeSnipit, mergeClassPath, inputParameters);
        this.executeChildren(config, inputClass, codeSnipit, mergeClassPath);
        return codeSnipit;
    }

    private void merge(JavaForgerConfiguration config, CodeSnipit codeSnipit, String mergeClassPath, TemplateInputParameters inputParameters) throws IOException, TemplateException {
        if (mergeClassPath != null && config.isMerge()) {
            boolean exists = new File(mergeClassPath).exists();
            if (!exists) {
                if (!config.isCreateFileIfNotExists()) {
                    throw new JavaForgerException("Merge file '" + mergeClassPath + "' does not exist and JavaForgerConfiguration for template " + config.getTemplateName() + " is not setup to create it. ");
                }
                if (config.getConfigIfFileDoesNotExist() == null) {
                    this.createAndFillFile(mergeClassPath, codeSnipit);
                } else {
                    CodeSnipit codeSnipitInit = this.processTemplate(config.getConfigIfFileDoesNotExist(), inputParameters);
                    this.createAndFillFile(mergeClassPath, codeSnipitInit);
                    this.executeMerge(config, codeSnipit, mergeClassPath);
                }
            } else {
                this.executeMerge(config, codeSnipit, mergeClassPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeMerge(JavaForgerConfiguration config, CodeSnipit codeSnipit, String mergeClassPath) throws IOException {
        boolean success = false;
        try {
            this.merger.merge(config, codeSnipit, mergeClassPath);
            success = true;
        }
        finally {
            if (!success) {
                codeSnipit.printWithLineNumbers();
            }
        }
    }

    private String getMergeClass(String inputClass, String parentMergeClass, JavaForgerConfiguration config) {
        ClassProvider provider = config.getMergeClassProvider();
        return provider == null ? null : provider.provide(inputClass, parentMergeClass);
    }

    private void createAndFillFile(String mergeClassPath, CodeSnipit codeSnipit) throws IOException {
        File f = new File(mergeClassPath);
        if (!f.exists()) {
            f.getParentFile().mkdirs();
        }
        try (PrintWriter writer = new PrintWriter(mergeClassPath, "UTF-8");){
            writer.write(codeSnipit.toString());
        }
    }

    private void executeChildren(JavaForgerConfiguration config, String parentInputClass, CodeSnipit codeSnipit, String parentMergeClass) throws IOException, TemplateException {
        ArrayList<CodeSnipit> codeSnipits = new ArrayList<CodeSnipit>();
        for (JavaForgerConfiguration conf : config.getChildConfigs()) {
            String inputClass = conf.getInputClassProvider().provide(parentInputClass, parentMergeClass);
            codeSnipits.add(this.execute(conf, inputClass, parentMergeClass));
        }
        codeSnipits.forEach(s -> {
            codeSnipit.add("\n======================================================================\n");
            codeSnipit.add(s.toString());
        });
    }

    private CodeSnipit processTemplate(JavaForgerConfiguration config, TemplateInputParameters inputParameters) throws IOException, TemplateNotFoundException, MalformedTemplateNameException, ParseException, TemplateException {
        StringWriter writer = new StringWriter();
        this.staticConfig.getFreeMarkerConfiguration().getTemplate(config.getTemplate()).process((Object)inputParameters, (Writer)writer);
        return new CodeSnipit(((Object)writer).toString());
    }
}

