/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import configuration.PathConverter;
import generator.JavaForgerException;
import java.util.function.Function;

public class ClassProvider {
    private final ProvideFrom provideFrom;
    private final Function<String, String> provide;

    public ClassProvider() {
        this.provideFrom = ProvideFrom.INPUT_CLASS;
        this.provide = s -> {
            this.validate((String)s);
            return s;
        };
    }

    public ClassProvider(String path) {
        this.provideFrom = ProvideFrom.SELF;
        this.provide = s -> path;
    }

    public ClassProvider(ProvideFrom provideFrom, Function<String, String> provide) {
        this.provideFrom = provideFrom;
        this.provide = provide;
    }

    public static ClassProvider fromInputClass(Function<String, String> provider) {
        return new ClassProvider(ProvideFrom.INPUT_CLASS, provider);
    }

    public static ClassProvider fromParentMergeClass() {
        return ClassProvider.fromParentMergeClass(s -> s);
    }

    public static ClassProvider fromParentMergeClass(Function<String, String> provider) {
        return new ClassProvider(ProvideFrom.PARENT_CONFIG_MERGE_CLASS, provider);
    }

    public static ClassProvider forMavenUnitTestFromInput() {
        return new ClassProvider(ProvideFrom.INPUT_CLASS, s -> PathConverter.toMavenUnitTestPath(s));
    }

    public static ClassProvider forMavenUnitTestFromParent() {
        return new ClassProvider(ProvideFrom.PARENT_CONFIG_MERGE_CLASS, s -> PathConverter.toMavenUnitTestPath(s));
    }

    public static ClassProvider sameAsParentMergeClass() {
        return new ClassProvider(ProvideFrom.PARENT_CONFIG_MERGE_CLASS, s -> s);
    }

    public String provide(String path) {
        return this.provide.apply(path);
    }

    public String provide(String parentInputClass, String parentMergeClass) {
        String path;
        switch (this.provideFrom) {
            case INPUT_CLASS: {
                path = parentInputClass;
                break;
            }
            case PARENT_CONFIG_MERGE_CLASS: {
                path = parentMergeClass;
                break;
            }
            default: {
                path = "";
            }
        }
        return this.provide(path);
    }

    public ProvideFrom provideFrom() {
        return this.provideFrom;
    }

    private void validate(String claz) {
        if (claz == null) {
            throw new JavaForgerException("input class path may not be null");
        }
        if (claz.isEmpty()) {
            throw new JavaForgerException("input class path may not be empty");
        }
    }

    public static enum ProvideFrom {
        SELF,
        PARENT_CONFIG_MERGE_CLASS,
        INPUT_CLASS;

    }
}

