/*
 * Decompiled with CFR 0.152.
 */
package reader;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import dataflow.DataFlowGraphFactory;
import dataflow.NodeCallFactory;
import dataflow.model.DataFlowGraph;
import generator.JavaForgerException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reader.MethodDefinitionFactory;
import reader.VariableDefintionFactory;
import templateInput.ClassContainer;
import templateInput.definition.ClassDefinition;
import templateInput.definition.MethodDefinition;
import templateInput.definition.VariableDefinition;

public class ClassContainerReader {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCallFactory.class);
    private DataFlowGraphFactory dfgFactory = new DataFlowGraphFactory();
    private MethodDefinitionFactory methodFactory = new MethodDefinitionFactory();
    private VariableDefintionFactory fieldFactory = new VariableDefintionFactory();

    public ClassContainer read(String inputClass) throws IOException {
        CompilationUnit cu = this.getCompilationUnit(inputClass);
        DataFlowGraph dfg = null;
        try {
            dfg = this.dfgFactory.create(cu);
        }
        catch (Exception e) {
            LOG.error("Error creating dataFlowGraph: {}", (Throwable)e);
        }
        ClassContainer claz = this.readCompilationUnit(cu, dfg);
        return claz;
    }

    private CompilationUnit getCompilationUnit(String inputClass) throws IOException {
        CompilationUnit cu = null;
        try (FileInputStream in = new FileInputStream(inputClass);){
            cu = StaticJavaParser.parse((InputStream)in);
            in.close();
        }
        catch (FileNotFoundException e) {
            throw new JavaForgerException(e, "Could not parse " + inputClass);
        }
        return cu;
    }

    private ClassContainer readCompilationUnit(CompilationUnit cu, DataFlowGraph dfg) {
        ClassContainer claz = new ClassContainer();
        ArrayList<VariableDefinition> fields = new ArrayList<VariableDefinition>();
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        ArrayList<MethodDefinition> constructors = new ArrayList<MethodDefinition>();
        for (TypeDeclaration type : cu.getTypes()) {
            if (type instanceof ClassOrInterfaceDeclaration) {
                claz = this.parseClass(type);
            }
            List childNodes = type.getChildNodes();
            for (Node node : childNodes) {
                if (node instanceof FieldDeclaration) {
                    fields.addAll(this.fieldFactory.create(node));
                    continue;
                }
                if (node instanceof MethodDeclaration) {
                    MethodDefinition newMethod = this.methodFactory.createMethod(node, dfg);
                    methods.add(newMethod);
                    continue;
                }
                if (!(node instanceof ConstructorDeclaration)) continue;
                MethodDefinition constructor = this.methodFactory.createConstructor(node);
                constructors.add(constructor);
            }
        }
        Optional<String> typeImport = cu.getPackageDeclaration().map(pd -> pd.getNameAsString());
        if (typeImport.isPresent()) {
            claz.addTypeImport(typeImport.get() + "." + claz.getName());
            constructors.forEach(c -> c.addTypeImport((String)typeImport.get()));
        }
        claz.setFields(fields);
        claz.setMethods(methods);
        claz.setConstructors(constructors);
        return claz;
    }

    private ClassContainer parseClass(TypeDeclaration<?> type) {
        ClassOrInterfaceDeclaration cd = (ClassOrInterfaceDeclaration)type;
        Set<String> annotations = cd.getAnnotations().stream().map(annotation -> annotation.getName().toString()).collect(Collectors.toSet());
        Set<String> accessModifiers = cd.getModifiers().stream().map(Node::toString).map(String::trim).collect(Collectors.toSet());
        List<String> interfaces = cd.getImplementedTypes().stream().map(NodeWithSimpleName::getNameAsString).collect(Collectors.toList());
        String extend = cd.getExtendedTypes().stream().findFirst().map(NodeWithSimpleName::getNameAsString).orElse(null);
        ClassDefinition def = ClassDefinition.builder().name(cd.getNameAsString()).type(cd.getNameAsString()).lineNumber(cd.getBegin().map(p -> p.line).orElse(-1)).column(cd.getBegin().map(p -> p.column).orElse(-1)).annotations(annotations).accessModifiers(accessModifiers).extend(extend).interfaces(interfaces).build();
        return new ClassContainer(def);
    }
}

